/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.webhook.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.community.notify.template.AbstractTemplate;
import org.jetlinks.community.notify.webhook.http.HttpWebHookProperties;
import org.jetlinks.core.Values;
import org.springframework.http.HttpMethod;
import org.springframework.util.ObjectUtils;

public class HttpWebHookTemplate
extends AbstractTemplate<HttpWebHookTemplate> {
    @Schema(description="\u8bf7\u6c42\u5730\u5740")
    private String url = "";
    @Schema(description="\u8bf7\u6c42\u5934")
    private List<HttpWebHookProperties.Header> headers;
    @Schema(description="\u8bf7\u6c42\u65b9\u5f0f,\u9ed8\u8ba4POST")
    private HttpMethod method = HttpMethod.POST;
    @Schema(description="\u4f7f\u7528\u4e0a\u4e0b\u6587\u4f5c\u4e3a\u8bf7\u6c42\u4f53")
    private boolean contextAsBody;
    @Schema(description="\u81ea\u5b9a\u4e49\u8bf7\u6c42\u4f53")
    private String body;
    @Hidden
    private Boolean bodyIsJson;

    public String resolveBody(Values context) {
        Map contextVal = this.renderMap(context.getAllValues());
        if (this.contextAsBody) {
            return JSON.toJSONString((Object)contextVal);
        }
        try {
            if (this.bodyIsJson == null || this.bodyIsJson.booleanValue()) {
                String _body = JSON.toJSONString((Object)this.resolveBody(JSON.parse((String)this.body), (Map<String, Object>)contextVal));
                this.bodyIsJson = true;
                return _body;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.bodyIsJson = false;
        return this.render(this.body, contextVal);
    }

    private Object resolveBody(Object val, Map<String, Object> context) {
        if (val instanceof String) {
            return this.render(String.valueOf(val), context);
        }
        if (val instanceof Map) {
            return this.resolveBody((Map)val, context);
        }
        if (val instanceof List) {
            return this.resolveBody((List)val, context);
        }
        return val;
    }

    private Map<Object, Object> resolveBody(Map<?, ?> obj, Map<String, Object> context) {
        LinkedHashMap val = Maps.newLinkedHashMapWithExpectedSize((int)obj.size());
        for (Map.Entry<?, ?> entry : obj.entrySet()) {
            Object key = this.resolveBody(entry.getKey(), context);
            if (ObjectUtils.isEmpty((Object)key)) continue;
            val.put(key, this.resolveBody(entry.getValue(), context));
        }
        return val;
    }

    private List<Object> resolveBody(List<?> obj, Map<String, Object> context) {
        ArrayList<Object> array = new ArrayList<Object>(obj.size());
        for (Object val : obj) {
            array.add(this.resolveBody(val, context));
        }
        return array;
    }

    public String getUrl() {
        return this.url;
    }

    public List<HttpWebHookProperties.Header> getHeaders() {
        return this.headers;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public boolean isContextAsBody() {
        return this.contextAsBody;
    }

    public String getBody() {
        return this.body;
    }

    public Boolean getBodyIsJson() {
        return this.bodyIsJson;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(List<HttpWebHookProperties.Header> headers) {
        this.headers = headers;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setContextAsBody(boolean contextAsBody) {
        this.contextAsBody = contextAsBody;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBodyIsJson(Boolean bodyIsJson) {
        this.bodyIsJson = bodyIsJson;
    }
}

