/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.ValidationException;
import org.jetlinks.community.notify.manager.entity.NotifyTemplateEntity;
import org.jetlinks.community.notify.manager.service.NotifyConfigService;
import org.jetlinks.community.notify.manager.service.NotifyTemplateService;
import org.jetlinks.community.notify.manager.web.response.TemplateInfo;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/notifier/template"})
@Authorize
@Resource(id="template", name="\u901a\u77e5\u6a21\u677f")
@Tag(name="\u6d88\u606f\u901a\u77e5\u6a21\u7248")
public class NotifierTemplateController
implements ReactiveServiceCrudController<NotifyTemplateEntity, String> {
    private final NotifyTemplateService templateService;
    private final List<TemplateProvider> providers;
    private final NotifyConfigService configService;

    public NotifierTemplateController(NotifyTemplateService templateService, NotifyConfigService configService, List<TemplateProvider> providers) {
        this.templateService = templateService;
        this.providers = providers;
        this.configService = configService;
    }

    public ReactiveCrudService<NotifyTemplateEntity, String> getService() {
        return this.templateService;
    }

    @PostMapping(value={"/{configId}/_query"})
    @QueryAction
    @Operation(summary="\u6839\u636e\u914d\u7f6eID\u67e5\u8be2\u901a\u77e5\u6a21\u7248\u5217\u8868")
    public Flux<NotifyTemplateEntity> queryTemplatesByConfigId(@PathVariable @Parameter(description="\u914d\u7f6eID") String configId, @RequestBody Mono<QueryParamEntity> query) {
        return this.configService.findById(configId).flatMapMany(conf -> query.flatMapMany(param -> (Flux)param.toNestQuery(nest -> ((Query)((Query)nest.is(NotifyTemplateEntity::getType, (Object)conf.getType())).is(NotifyTemplateEntity::getProvider, (Object)conf.getProvider())).nest().is(NotifyTemplateEntity::getConfigId, (Object)configId).or().isNull(NotifyTemplateEntity::getConfigId).isEmpty(NotifyTemplateEntity::getConfigId)).noPaging().execute(arg_0 -> ((NotifyTemplateService)this.templateService).query(arg_0))));
    }

    @GetMapping(value={"/{templateId}/detail"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6a21\u7248\u8be6\u60c5\u4fe1\u606f")
    public Mono<TemplateInfo> getTemplateDetail(@PathVariable @Parameter(description="\u6a21\u7248ID") String templateId) {
        return this.templateService.findById(templateId).flatMap(e -> {
            TemplateInfo info = new TemplateInfo();
            info.setId(e.getId());
            info.setName(e.getName());
            return this.getProvider(e.getType(), e.getProvider()).createTemplate(e.toTemplateProperties()).doOnNext(t -> info.setVariableDefinitions(new ArrayList<VariableDefinition>(t.getVariables().values()))).thenReturn((Object)info);
        });
    }

    @GetMapping(value={"/{type}/{provider}/config/metadata"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u548c\u670d\u52a1\u5546\u6240\u9700\u6a21\u7248\u914d\u7f6e\u5b9a\u4e49")
    public Mono<ConfigMetadata> getConfigMetadata(@PathVariable @Parameter(description="\u901a\u77e5\u7c7b\u578bID") String type, @PathVariable @Parameter(description="\u670d\u52a1\u5546ID") String provider) {
        return Mono.justOrEmpty((Object)this.getProvider(type, provider).getTemplateConfigMetadata());
    }

    public TemplateProvider getProvider(String type, String provider) {
        for (TemplateProvider prov : this.providers) {
            if (!prov.getType().getId().equalsIgnoreCase(type) || !prov.getProvider().getId().equalsIgnoreCase(provider)) continue;
            return prov;
        }
        throw new ValidationException("error.unsupported_notify_provider");
    }
}

