/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.subscriber.providers;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Objects;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.notify.manager.subscriber.Notify;
import org.jetlinks.community.notify.manager.subscriber.Subscriber;
import org.jetlinks.community.notify.manager.subscriber.SubscriberProvider;
import org.jetlinks.community.topic.Topics;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class AlarmProvider
implements SubscriberProvider {
    private final EventBus eventBus;

    public AlarmProvider(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public String getId() {
        return "alarm";
    }

    @Override
    public String getName() {
        return "\u544a\u8b66";
    }

    @Override
    public ConfigMetadata getConfigMetadata() {
        return new DefaultConfigMetadata().add("alarmConfigId", "\u544a\u8b66\u89c4\u5219", "\u544a\u8b66\u89c4\u5219,\u652f\u6301\u901a\u914d\u7b26:*", (DataType)StringType.GLOBAL);
    }

    @Override
    public Mono<Subscriber> createSubscriber(String id, Authentication authentication, Map<String, Object> config) {
        ValueObject configs = ValueObject.of(config);
        String alarmId = configs.getString("alarmConfigId").orElse("*");
        String topic = Topics.alarm((String)"*", (String)"*", (String)alarmId);
        return Mono.justOrEmpty(() -> this.createSubscribe(id, new String[]{topic}));
    }

    private Flux<Notify> createSubscribe(String id, String[] topics) {
        Subscription.Feature[] features = new Subscription.Feature[]{Subscription.Feature.local};
        return Flux.defer(() -> this.eventBus.subscribe(Subscription.of((String)("alarm:" + id), (String[])topics, (Subscription.Feature[])features)).map(msg -> {
            JSONObject json = msg.bodyToJson();
            return Notify.of(AlarmProvider.getNotifyMessage(json), json.getString("id"), System.currentTimeMillis(), "alarm", json);
        }));
    }

    private static String getNotifyMessage(JSONObject json) {
        TargetType targetType = TargetType.of(json.getString("targetType"));
        String targetName = json.getString("targetName");
        String alarmName = json.getString("alarmName");
        String message = targetType == TargetType.other ? String.format("[%s]\u53d1\u751f\u544a\u8b66:[%s]!", targetName, alarmName) : String.format("%s[%s]\u53d1\u751f\u544a\u8b66:[%s]!", targetType.getText(), targetName, alarmName);
        return LocaleUtils.resolveMessage((String)("message.alarm.notify." + targetType.name()), (String)message, (Object[])new Object[]{targetName, alarmName});
    }

    @Override
    public Flux<PropertyMetadata> getDetailProperties(Map<String, Object> config) {
        return Flux.just((Object[])new PropertyMetadata[]{SimplePropertyMetadata.of((String)"targetType", (String)"\u544a\u8b66\u7c7b\u578b", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"alarmName", (String)"\u544a\u8b66\u540d\u79f0", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"targetName", (String)"\u76ee\u6807\u540d\u79f0", (DataType)StringType.GLOBAL)});
    }

    static enum TargetType {
        device("\u8bbe\u5907"),
        product("\u4ea7\u54c1"),
        other("\u5176\u5b83");

        private final String text;

        public static TargetType of(String name) {
            for (TargetType value : TargetType.values()) {
                if (!Objects.equals(value.name(), name)) continue;
                return value;
            }
            return other;
        }

        private TargetType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

