/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.service;

import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.notify.event.SerializableNotifierEvent;
import org.jetlinks.community.notify.manager.service.NotifyHistory;
import org.jetlinks.community.notify.manager.service.NotifyHistoryRepository;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Component
public class ElasticSearchNotifyHistoryRepository
implements NotifyHistoryRepository {
    public static final String INDEX_NAME = "notify_history";
    private final ElasticSearchService elasticSearchService;
    private final ElasticSearchIndexManager indexManager;

    @PostConstruct
    public void init() {
        this.indexManager.putIndex((ElasticSearchIndexMetadata)new DefaultElasticSearchIndexMetadata(INDEX_NAME).addProperty("id", (DataType)StringType.GLOBAL).addProperty("notifyTime", (DataType)DateTimeType.GLOBAL)).block(Duration.ofSeconds(10L));
    }

    @Subscribe(value={"/notify/**"})
    @Transactional(propagation=Propagation.NEVER)
    public Mono<Void> handleNotify(SerializableNotifierEvent event) {
        return this.elasticSearchService.commit(INDEX_NAME, (Object)NotifyHistory.of(event).toJson());
    }

    @Override
    public Mono<PagerResult<NotifyHistory>> queryPager(QueryParamEntity param) {
        return this.elasticSearchService.queryPager(INDEX_NAME, (QueryParam)param, map -> {
            NotifyHistory history = (NotifyHistory)FastBeanCopier.copy((Object)map, (Object)new NotifyHistory(), (String[])new String[]{"context"});
            history.setContext((Map<String, Object>)JSON.parseObject((String)map.getOrDefault("context", "{}")));
            return history;
        });
    }

    public ElasticSearchNotifyHistoryRepository(ElasticSearchService elasticSearchService, ElasticSearchIndexManager indexManager) {
        this.elasticSearchService = elasticSearchService;
        this.indexManager = indexManager;
    }
}

