/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.service;

import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.manager.entity.NotifyTemplateEntity;
import org.jetlinks.community.notify.manager.service.NotifyTemplateService;
import org.jetlinks.community.notify.template.AbstractTemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class DefaultTemplateManager
extends AbstractTemplateManager
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultTemplateManager.class);
    private final NotifyTemplateService templateService;

    public DefaultTemplateManager(NotifyTemplateService templateService) {
        this.templateService = templateService;
    }

    protected Mono<TemplateProperties> getProperties(NotifyType type, String id) {
        return this.templateService.findById(Mono.just((Object)id)).map(NotifyTemplateEntity::toTemplateProperties);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof TemplateProvider) {
            this.register((TemplateProvider)bean);
        }
        return bean;
    }
}

