/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.annotation.NotifierResource;
import org.jetlinks.community.notify.dingtalk.corp.CorpDepartment;
import org.jetlinks.community.notify.dingtalk.corp.CorpUser;
import org.jetlinks.community.notify.dingtalk.corp.request.GetDepartmentRequest;
import org.jetlinks.community.notify.dingtalk.corp.request.GetUserRequest;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/notifier/dingtalk/corp"})
@NotifierResource
@Tag(name="\u9489\u9489\u4f01\u4e1a\u6d88\u606f\u901a\u77e5")
public class DingTalkCorpNotifierController {
    private final NotifierManager notifierManager;

    @GetMapping(value={"/{configId}/departments"})
    @Operation(summary="\u83b7\u53d6\u4f01\u4e1a\u90e8\u95e8\u4fe1\u606f")
    public Flux<CorpDepartment> getDepartments(@PathVariable String configId, @RequestParam(defaultValue="false") boolean fetchChild) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.dingTalk, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMapMany(support -> (Flux)support.execute((Command)new GetDepartmentRequest(fetchChild)));
    }

    @GetMapping(value={"/{configId}/departments/tree"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u4f01\u4e1a\u90e8\u95e8\u4fe1\u606f(\u6811\u7ed3\u6784)")
    public Flux<CorpDepartment> getDepartments(@PathVariable String configId) {
        return this.getDepartments(configId, true).collectList().flatMapIterable(CorpDepartment::toTree);
    }

    @GetMapping(value={"/{configId}/{departmentId}/users"})
    @Operation(summary="\u83b7\u53d6\u4f01\u4e1a\u90e8\u95e8\u4e0b\u4eba\u5458\u4fe1\u606f")
    public Flux<CorpUser> getDepartmentUsers(@PathVariable String configId, @PathVariable String departmentId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.dingTalk, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMapMany(support -> (Flux)support.execute((Command)new GetUserRequest(departmentId)));
    }

    @GetMapping(value={"/{configId}/users"})
    @Operation(summary="\u83b7\u53d6\u4f01\u4e1a\u90e8\u95e8\u4e0b\u5168\u90e8\u4eba\u5458\u4fe1\u606f")
    public Flux<CorpUser> getDepartmentUsers(@PathVariable String configId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.dingTalk, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMapMany(support -> ((Flux)support.execute((Command)new GetDepartmentRequest(true))).flatMap(department -> (Flux)support.execute((Command)new GetUserRequest(department.getId()))));
    }

    public DingTalkCorpNotifierController(NotifierManager notifierManager) {
        this.notifierManager = notifierManager;
    }
}

