/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.robot;

import javax.annotation.Nonnull;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.dingtalk.DingTalkProvider;
import org.jetlinks.community.notify.dingtalk.robot.DingTalkRobotWebHookNotifier;
import org.jetlinks.community.notify.dingtalk.robot.DingTalkWebHookTemplate;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.FileType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class DingTalkRobotWebHookNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private final WebClient client;
    private final TemplateManager templateManager;
    public static final DefaultConfigMetadata notifierConfig = new DefaultConfigMetadata("\u901a\u77e5\u914d\u7f6e", "").add("url", "Webhook", "", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.required.value((Object)true)}));
    public static final DefaultConfigMetadata templateConfig = new DefaultConfigMetadata("\u6a21\u7248\u914d\u7f6e", "").add("messageType", "\u6d88\u606f\u7c7b\u578b", "", (DataType)new EnumType().addElement(EnumType.Element.of((String)"text", (String)"text")).addElement(EnumType.Element.of((String)"link", (String)"link")).addElement(EnumType.Element.of((String)"markdown", (String)"markdown")).expand(new ConfigKeyValue[]{ConfigMetadataConstants.required.value((Object)true)})).add("text", "\u6587\u672c\u6d88\u606f", "", (DataType)new ObjectType().addProperty("content", "\u6587\u672c\u5185\u5bb9", (DataType)StringType.GLOBAL)).add("link", "\u8fde\u63a5\u6d88\u606f", "", (DataType)new ObjectType().addProperty("title", "\u6807\u9898", (DataType)StringType.GLOBAL).addProperty("picUrl", "\u56fe\u7247\u5730\u5740", (DataType)new FileType()).addProperty("text", "\u6b63\u6587", (DataType)StringType.GLOBAL).addProperty("messageUrl", "\u6d88\u606f\u8fde\u63a5", (DataType)StringType.GLOBAL)).add("markdown", "markdown\u6d88\u606f", "\u63a8\u9001\u5230\u5168\u90e8\u7528\u6237", (DataType)new ObjectType().addProperty("title", "\u6807\u9898", (DataType)StringType.GLOBAL).addProperty("text", "\u6b63\u6587", (DataType)StringType.GLOBAL)).add("at", "At", "At\u6307\u5b9a\u7684\u4eba", (DataType)new ObjectType().addProperty("atMobiles", "\u6309\u624b\u673a\u53f7\u7801at", (DataType)new ArrayType().elementType((DataType)StringType.GLOBAL)).addProperty("atUserIds", "\u6309\u7528\u6237IDat", (DataType)new ArrayType().elementType((DataType)StringType.GLOBAL)).addProperty("atAll", "\u662f\u5426at\u5168\u5458", (DataType)BooleanType.GLOBAL));

    public DingTalkRobotWebHookNotifierProvider(TemplateManager templateManager, WebClient.Builder builder) {
        this.templateManager = templateManager;
        this.client = builder.build();
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.dingTalk;
    }

    @Nonnull
    public Provider getProvider() {
        return DingTalkProvider.dingTalkRobotWebHook;
    }

    public Mono<DingTalkWebHookTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.fromSupplier(() -> ((DingTalkWebHookTemplate)new DingTalkWebHookTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    @Nonnull
    public Mono<DingTalkRobotWebHookNotifier> createNotifier(@Nonnull NotifierProperties properties) {
        return (Mono)Mono.fromSupplier(() -> {
            String url = properties.getString("url").filter(StringUtils::hasText).orElseThrow(() -> new IllegalArgumentException("url can not be null"));
            return new DingTalkRobotWebHookNotifier(properties.getId(), this.templateManager, url, this.client);
        }).as(LocaleUtils::transform);
    }

    public ConfigMetadata getNotifierConfigMetadata() {
        return notifierConfig;
    }

    public ConfigMetadata getTemplateConfigMetadata() {
        return templateConfig;
    }
}

