/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.corp;

import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.dingtalk.DingTalkProvider;
import org.jetlinks.community.notify.dingtalk.corp.DingTalkMessageTemplate;
import org.jetlinks.community.notify.dingtalk.corp.DingTalkNotifier;
import org.jetlinks.community.notify.dingtalk.corp.DingTalkProperties;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class DingTalkNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private final WebClient.Builder clientBuilder;
    private final TemplateManager templateManager;
    public static final DefaultConfigMetadata notifierConfig = new DefaultConfigMetadata("\u901a\u77e5\u914d\u7f6e", "").add("appKey", "appKey", "", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.required.value((Object)true)})).add("appSecret", "appSecret", "", (DataType)new StringType());
    public static final DefaultConfigMetadata templateConfig = new DefaultConfigMetadata("\u6a21\u7248\u914d\u7f6e", "").add("agentId", "\u5e94\u7528ID", "", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.required.value((Object)true)})).add("userIdList", "\u6536\u4fe1\u4ebaID", "\u4e0e\u90e8\u95e8ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (DataType)new StringType()).add("departmentIdList", "\u6536\u4fe1\u90e8\u95e8ID", "\u4e0e\u6536\u4fe1\u4ebaID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (DataType)new StringType()).add("toAllUser", "\u5168\u90e8\u7528\u6237", "\u63a8\u9001\u5230\u5168\u90e8\u7528\u6237", (DataType)new BooleanType()).add("message", "\u5185\u5bb9", "\u6700\u5927\u4e0d\u8d85\u8fc7500\u5b57", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.maxLength.value((Object)500L)}));

    public DingTalkNotifierProvider(TemplateManager templateManager, WebClient.Builder builder) {
        this.templateManager = templateManager;
        this.clientBuilder = builder;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.dingTalk;
    }

    @Nonnull
    public Provider getProvider() {
        return DingTalkProvider.dingTalkMessage;
    }

    public Mono<DingTalkMessageTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.fromSupplier(() -> (DingTalkMessageTemplate)((DingTalkMessageTemplate)new DingTalkMessageTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    @Nonnull
    public Mono<DingTalkNotifier> createNotifier(@Nonnull NotifierProperties properties) {
        return (Mono)Mono.defer(() -> {
            DingTalkProperties dingTalkProperties = (DingTalkProperties)FastBeanCopier.copy((Object)properties.getConfiguration(), (Object)new DingTalkProperties(), (String[])new String[0]);
            return (Mono)Mono.just((Object)((Object)new DingTalkNotifier(properties.getId(), this.clientBuilder, (DingTalkProperties)ValidatorUtils.tryValidate((Object)dingTalkProperties, (Class[])new Class[0]), this.templateManager))).as(LocaleUtils::transform);
        }).as(LocaleUtils::transform);
    }

    public ConfigMetadata getNotifierConfigMetadata() {
        return notifierConfig;
    }

    public ConfigMetadata getTemplateConfigMetadata() {
        return templateConfig;
    }
}

