/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.wechat.corp;

import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.community.notify.wechat.WechatProvider;
import org.jetlinks.community.notify.wechat.corp.WechatCorpNotifier;
import org.jetlinks.community.notify.wechat.corp.WechatCorpProperties;
import org.jetlinks.community.notify.wechat.corp.WechatMessageTemplate;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class WechatNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private final WebClient.Builder clientBuilder;
    private final TemplateManager templateManager;
    public static final DefaultConfigMetadata notifierConfig = new DefaultConfigMetadata("\u901a\u77e5\u914d\u7f6e", "").add("corpId", "corpId", "", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.required.value((Object)true)})).add("corpSecret", "corpSecret", "", (DataType)new StringType());
    public static final DefaultConfigMetadata templateConfig = new DefaultConfigMetadata("\u6a21\u7248\u914d\u7f6e", "").add("agentId", "\u5e94\u7528ID", "", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.required.value((Object)true)})).add("toUser", "\u6536\u4fe1\u4ebaID", "\u4e0e\u90e8\u95e8ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (DataType)new StringType()).add("toParty", "\u6536\u4fe1\u90e8\u95e8ID", "\u4e0e\u6536\u4fe1\u4ebaID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (DataType)new StringType()).add("toTag", "\u6309\u6807\u7b7e\u63a8\u9001", "", (DataType)new StringType()).add("message", "\u5185\u5bb9", "\u6700\u5927\u4e0d\u8d85\u8fc7500\u5b57", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.maxLength.value((Object)500L)}));

    public WechatNotifierProvider(TemplateManager templateManager, WebClient.Builder builder) {
        this.templateManager = templateManager;
        this.clientBuilder = builder;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.weixin;
    }

    @Nonnull
    public Provider getProvider() {
        return WechatProvider.corpMessage;
    }

    public Mono<WechatMessageTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.fromSupplier(() -> (WechatMessageTemplate)((WechatMessageTemplate)new WechatMessageTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    @Nonnull
    public Mono<WechatCorpNotifier> createNotifier(@Nonnull NotifierProperties properties) {
        return (Mono)Mono.defer(() -> {
            WechatCorpProperties wechatCorpProperties = (WechatCorpProperties)FastBeanCopier.copy((Object)properties.getConfiguration(), (Object)new WechatCorpProperties(), (String[])new String[0]);
            return Mono.just((Object)((Object)new WechatCorpNotifier(properties.getId(), this.clientBuilder, (WechatCorpProperties)ValidatorUtils.tryValidate((Object)wechatCorpProperties, (Class[])new Class[0]), this.templateManager)));
        }).as(LocaleUtils::transform);
    }

    public ConfigMetadata getNotifierConfigMetadata() {
        return notifierConfig;
    }

    public ConfigMetadata getTemplateConfigMetadata() {
        return templateConfig;
    }
}

