/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.sms.aliyun;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotBlank;
import org.jetlinks.community.notify.template.AbstractTemplate;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.community.relation.RelationConstants;
import org.jetlinks.community.relation.utils.RelationUtils;
import org.jetlinks.core.config.ConfigKey;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class AliyunSmsTemplate
extends AbstractTemplate<AliyunSmsTemplate> {
    public static final String PHONE_NUMBER_KEY = "phoneNumber";
    @NotBlank(message="[signName]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="[signName]\u4e0d\u80fd\u4e3a\u7a7a") String signName;
    @NotBlank(message="[code]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="[code]\u4e0d\u80fd\u4e3a\u7a7a") String code;
    private String phoneNumber;
    private Map<String, String> param;

    public String getCode(Map<String, Object> ctx) {
        return this.getCode();
    }

    public Flux<String> getPhoneNumber(Map<String, Object> ctx) {
        if (StringUtils.hasText((String)this.getPhoneNumber())) {
            return Flux.just((Object)this.getPhoneNumber());
        }
        return RelationUtils.resolve((String)PHONE_NUMBER_KEY, ctx, (ConfigKey)RelationConstants.UserProperty.telephone).map(String::valueOf);
    }

    public String getSignName(Map<String, Object> ctx) {
        return this.getSignName();
    }

    public String createTtsParam(Map<String, Object> ctx) {
        return JSON.toJSONString(ctx);
    }

    @Nonnull
    protected List<VariableDefinition> getEmbeddedVariables() {
        if (StringUtils.hasText((String)this.phoneNumber)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(VariableDefinition.builder().id(PHONE_NUMBER_KEY).name("\u6536\u4fe1\u4eba").description("\u6536\u4fe1\u4eba\u624b\u673a\u53f7\u7801").expand("businessType", (Object)"user").type("string").required(true).build());
    }

    public String getSignName() {
        return this.signName;
    }

    public String getCode() {
        return this.code;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public Map<String, String> getParam() {
        return this.param;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setParam(Map<String, String> param) {
        this.param = param;
    }
}

