/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.corp.request;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.jetlinks.community.notify.dingtalk.corp.CorpUser;
import org.jetlinks.community.notify.dingtalk.corp.request.ApiRequest;
import org.jetlinks.community.notify.dingtalk.corp.response.ApiResponse;
import org.reactivestreams.Publisher;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GetUserRequest
extends ApiRequest<Flux<CorpUser>> {
    private final String departmentId;

    @Override
    public Flux<CorpUser> execute(WebClient client) {
        return this.doRequest(0, client).flatMapIterable(Response::getList);
    }

    private Flux<Response> doRequest(int pageIndex, WebClient client) {
        return ((WebClient.RequestBodySpec)client.post().uri("/topapi/user/listsimple", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((String)"dept_id", (String)this.departmentId).with("cursor", (Object)String.valueOf(pageIndex)).with("size", (Object)"100")).retrieve().bodyToMono(Response.class).flatMapMany(response -> {
            if (((Response)response).hasMore && ((Response)response).nextCursor > 0) {
                return Flux.concat((Publisher[])new Publisher[]{Mono.just((Object)response), this.doRequest(((Response)response).nextCursor, client)});
            }
            return Mono.just((Object)response);
        });
    }

    public GetUserRequest(String departmentId) {
        this.departmentId = departmentId;
    }

    public static class Response
    extends ApiResponse {
        @JsonProperty
        @JsonAlias(value={"has_more"})
        private boolean hasMore;
        @JsonProperty
        @JsonAlias(value={"next_cursor"})
        private int nextCursor;
        @JsonProperty
        @JsonAlias(value={"result"})
        private Result result;

        public List<CorpUser> getList() {
            return this.result == null ? Collections.emptyList() : this.result.list;
        }

        public boolean isHasMore() {
            return this.hasMore;
        }

        public int getNextCursor() {
            return this.nextCursor;
        }

        public Result getResult() {
            return this.result;
        }

        @JsonProperty
        @JsonAlias(value={"has_more"})
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
        }

        @JsonProperty
        @JsonAlias(value={"next_cursor"})
        public void setNextCursor(int nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty
        @JsonAlias(value={"result"})
        public void setResult(Result result) {
            this.result = result;
        }

        public static class Result {
            @JsonProperty
            @JsonAlias(value={"has_more"})
            private boolean hasMore;
            @JsonProperty
            @JsonAlias(value={"list"})
            private List<CorpUser> list;

            public List<CorpUser> getList() {
                return this.list == null ? Collections.emptyList() : this.list;
            }

            public boolean isHasMore() {
                return this.hasMore;
            }

            @JsonProperty
            @JsonAlias(value={"has_more"})
            public void setHasMore(boolean hasMore) {
                this.hasMore = hasMore;
            }

            @JsonProperty
            @JsonAlias(value={"list"})
            public void setList(List<CorpUser> list) {
                this.list = list;
            }
        }
    }
}

