/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.logging.configuration;

import org.jetlinks.community.logging.configuration.LoggingProperties;
import org.jetlinks.community.logging.logback.SystemLoggingAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LoggingProperties.class})
public class LoggingConfiguration
implements ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(LoggingConfiguration.class);
    private final LoggingProperties properties;

    public LoggingConfiguration(LoggingProperties properties) {
        this.properties = properties;
        SystemLoggingAppender.staticContext.putAll(properties.getSystem().getContext());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        SystemLoggingAppender.publisher = applicationEventPublisher;
    }
}

