/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.monitor;

import java.util.function.Supplier;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;

class LazyDeviceGatewayMonitor
implements DeviceGatewayMonitor {
    private volatile DeviceGatewayMonitor target;
    private Supplier<DeviceGatewayMonitor> monitorSupplier;

    public LazyDeviceGatewayMonitor(Supplier<DeviceGatewayMonitor> monitorSupplier) {
        this.monitorSupplier = monitorSupplier;
    }

    public DeviceGatewayMonitor getTarget() {
        if (this.target == null) {
            this.target = this.monitorSupplier.get();
        }
        return this.target;
    }

    @Override
    public void totalConnection(long total) {
        this.getTarget().totalConnection(total);
    }

    @Override
    public void connected() {
        this.getTarget().connected();
    }

    @Override
    public void rejected() {
        this.getTarget().rejected();
    }

    @Override
    public void disconnected() {
        this.getTarget().disconnected();
    }

    @Override
    public void receivedMessage() {
        this.getTarget().receivedMessage();
    }

    @Override
    public void sentMessage() {
        this.getTarget().sentMessage();
    }
}

