/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.external;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.gateway.external.Message;
import org.jetlinks.community.gateway.external.MessagingManager;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import reactor.core.publisher.Flux;

@Component
public class DefaultMessagingManager
implements MessagingManager,
BeanPostProcessor {
    private final Map<String, SubscriptionProvider> subProvider = new ConcurrentHashMap<String, SubscriptionProvider>();
    private static final PathMatcher matcher = new AntPathMatcher();

    @Override
    public Flux<Message> subscribe(SubscribeRequest request) {
        return Flux.defer(() -> {
            for (Map.Entry<String, SubscriptionProvider> entry : this.subProvider.entrySet()) {
                if (!matcher.match(entry.getKey(), request.getTopic())) continue;
                return entry.getValue().subscribe(request).map(v -> {
                    if (v instanceof Message) {
                        return (Message)v;
                    }
                    return Message.success(request.getId(), request.getTopic(), v);
                });
            }
            return Flux.error((Throwable)new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684topic"));
        });
    }

    public void register(SubscriptionProvider provider) {
        for (String pattern : provider.getTopicPattern()) {
            this.subProvider.put(pattern, provider);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SubscriptionProvider) {
            this.register((SubscriptionProvider)bean);
        }
        return bean;
    }
}

