/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway;

import java.util.function.BiConsumer;
import org.jetlinks.community.gateway.GatewayState;
import org.jetlinks.core.message.Message;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeviceGateway {
    public String getId();

    public Flux<Message> onMessage();

    public Mono<Void> startup();

    public Mono<Void> pause();

    public Mono<Void> shutdown();

    default public boolean isAlive() {
        return true;
    }

    default public boolean isStarted() {
        return this.getState() == GatewayState.started;
    }

    default public GatewayState getState() {
        return GatewayState.started;
    }

    default public void doOnStateChange(BiConsumer<GatewayState, GatewayState> listener) {
    }

    default public void doOnShutdown(Disposable disposable) {
        this.doOnStateChange((before, after) -> {
            if (after == GatewayState.shutdown) {
                disposable.dispose();
            }
        });
    }
}

