/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.device.entity.DevicePropertiesEntity;
import org.jetlinks.community.utils.ErrorUtils;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.FunctionInvokeMessageSender;
import org.jetlinks.core.message.ReadPropertyMessageSender;
import org.jetlinks.core.message.WritePropertyMessageSender;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/device"})
@Authorize
@Resource(id="device-instance", name="\u8bbe\u5907\u5b9e\u4f8b")
@Tag(name="\u8bbe\u5907\u6307\u4ee4API")
@Deprecated
public class DeviceMessageController {
    private static final Logger log = LoggerFactory.getLogger(DeviceMessageController.class);
    @Autowired
    private DeviceRegistry registry;

    @GetMapping(value={"/{deviceId}/property/{property:.+}"})
    @Deprecated
    public Flux<?> getProperty(@PathVariable String deviceId, @PathVariable String property) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"\u8bbe\u5907\u4e0d\u5b58\u5728")).map(DeviceOperator::messageSender).map(sender -> sender.readProperty(new String[]{property}).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate())).flatMapMany(ReadPropertyMessageSender::send).map(DeviceMessageController.mapReply(ReadPropertyMessageReply::getProperties));
    }

    @GetMapping(value={"/standard/{deviceId}/property/{property:.+}"})
    @Deprecated
    public Mono<DevicePropertiesEntity> getStandardProperty(@PathVariable String deviceId, @PathVariable String property) {
        return Mono.from((Publisher)this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"\u8bbe\u5907\u4e0d\u5b58\u5728")).flatMapMany(deviceOperator -> deviceOperator.messageSender().readProperty(new String[]{property}).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).send().map(DeviceMessageController.mapReply(ReadPropertyMessageReply::getProperties)).flatMap(map -> {
            Object value = map.get(property);
            return deviceOperator.getMetadata().map(deviceMetadata -> deviceMetadata.getProperty(property).map(PropertyMetadata::getValueType).orElse((DataType)new StringType())).map(dataType -> DevicePropertiesEntity.builder().deviceId(deviceId).productId(property).build().withValue((DataType)dataType, value));
        })));
    }

    @PostMapping(value={"/setting/{deviceId}/property"})
    @Deprecated
    public Flux<?> settingProperties(@PathVariable String deviceId, @RequestBody Map<String, Object> properties) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"\u8bbe\u5907\u4e0d\u5b58\u5728")).map(operator -> operator.messageSender().writeProperty().messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).write(properties)).flatMapMany(WritePropertyMessageSender::send).map(DeviceMessageController.mapReply(WritePropertyMessageReply::getProperties));
    }

    @PostMapping(value={"invoked/{deviceId}/function/{functionId}"})
    @Deprecated
    public Flux<?> invokedFunction(@PathVariable String deviceId, @PathVariable String functionId, @RequestBody Map<String, Object> properties) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"\u8bbe\u5907\u4e0d\u5b58\u5728")).flatMap(operator -> operator.messageSender().invokeFunction(functionId).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).setParameter(properties).validate()).flatMapMany(FunctionInvokeMessageSender::send).map(DeviceMessageController.mapReply(FunctionInvokeMessageReply::getOutput));
    }

    @PostMapping(value={"/{deviceId}/properties"})
    @Deprecated
    public Flux<?> getProperties(@PathVariable String deviceId, @RequestBody Mono<List<String>> properties) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"\u8bbe\u5907\u4e0d\u5b58\u5728")).map(DeviceOperator::messageSender).flatMapMany(sender -> properties.flatMapMany(list -> sender.readProperty(list.toArray(new String[0])).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).send())).map(DeviceMessageController.mapReply(ReadPropertyMessageReply::getProperties));
    }

    private static <R extends DeviceMessageReply, T> Function<R, T> mapReply(Function<R, T> function) {
        return reply -> {
            if (ErrorCode.REQUEST_HANDLING.name().equals(reply.getCode())) {
                throw new DeviceOperationException(ErrorCode.REQUEST_HANDLING, reply.getMessage());
            }
            if (!reply.isSuccess()) {
                throw new BusinessException(reply.getMessage(), reply.getCode());
            }
            Object mapped = function.apply(reply);
            if (mapped == null) {
                throw new BusinessException(reply.getMessage(), reply.getCode());
            }
            return mapped;
        };
    }
}

