/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.data;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.device.entity.DeviceLatestData;
import org.jetlinks.community.doc.QueryConditionOnly;
import org.jetlinks.community.timeseries.query.AggregationColumn;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.metadata.DeviceMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeviceLatestDataService {
    public Mono<Void> upgradeMetadata(String var1, DeviceMetadata var2);

    public Mono<Void> reloadMetadata(String var1, DeviceMetadata var2);

    public void save(DeviceMessage var1);

    public Flux<DeviceLatestData> query(String var1, QueryParamEntity var2);

    public Mono<DeviceLatestData> queryDeviceData(String var1, String var2);

    public Mono<Integer> count(String var1, QueryParamEntity var2);

    default public Mono<PagerResult<DeviceLatestData>> queryPager(String productId, QueryParamEntity param) {
        return Mono.zip((Mono)this.query(productId, param).collectList(), this.count(productId, param), (data, total) -> PagerResult.of((int)total, (List)data, (QueryParam)param)).defaultIfEmpty((Object)PagerResult.empty());
    }

    public Mono<Map<String, Object>> aggregation(String var1, List<AggregationColumn> var2, QueryParamEntity var3);

    public Flux<Map<String, Object>> aggregation(Flux<QueryProductLatestDataRequest> var1, boolean var2);

    public static class QueryLatestDataRequest {
        @NotNull
        private List<AggregationColumn> columns;
        @Schema(implementation=QueryConditionOnly.class)
        private QueryParamEntity query = QueryParamEntity.of();

        @NotNull
        public List<AggregationColumn> getColumns() {
            return this.columns;
        }

        public QueryParamEntity getQuery() {
            return this.query;
        }

        public void setColumns(@NotNull List<AggregationColumn> columns) {
            this.columns = columns;
        }

        public void setQuery(QueryParamEntity query) {
            this.query = query;
        }
    }

    public static class QueryProductLatestDataRequest
    extends QueryLatestDataRequest {
        @NotBlank
        @Schema(defaultValue="\u4ea7\u54c1ID")
        private String productId;

        public String getProductId() {
            return this.productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }
    }
}

