/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.device.service.DeviceConfigMetadataManager;
import org.jetlinks.community.device.spi.DeviceConfigMetadataSupplier;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DeviceConfigScope;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DefaultDeviceConfigMetadataManager
implements DeviceConfigMetadataManager,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceConfigMetadataManager.class);
    private final List<DeviceConfigMetadataSupplier> suppliers = new CopyOnWriteArrayList<DeviceConfigMetadataSupplier>();

    protected void register(DeviceConfigMetadataSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public Flux<ConfigMetadata> getDeviceConfigMetadataByProductId(String productId) {
        return Flux.fromIterable(this.suppliers).flatMap(supplier -> supplier.getDeviceConfigMetadataByProductId(productId)).map(config -> config.copy(new ConfigScope[]{DeviceConfigScope.device})).filter(config -> !org.springframework.util.CollectionUtils.isEmpty((Collection)config.getProperties())).sort(Comparator.comparing(ConfigMetadata::getName));
    }

    @Override
    public Flux<ConfigMetadata> getDeviceConfigMetadata(String deviceId) {
        return Flux.fromIterable(this.suppliers).flatMap(supplier -> supplier.getDeviceConfigMetadata(deviceId)).map(config -> config.copy(new ConfigScope[]{DeviceConfigScope.device})).filter(config -> !org.springframework.util.CollectionUtils.isEmpty((Collection)config.getProperties())).sort(Comparator.comparing(ConfigMetadata::getName));
    }

    @Override
    public Flux<ConfigMetadata> getProductConfigMetadata(String productId) {
        return Flux.fromIterable(this.suppliers).flatMap(supplier -> supplier.getProductConfigMetadata(productId)).map(config -> config.copy(new ConfigScope[]{DeviceConfigScope.product})).filter(config -> !org.springframework.util.CollectionUtils.isEmpty((Collection)config.getProperties())).sort(Comparator.comparing(ConfigMetadata::getName));
    }

    @Override
    public Flux<ConfigMetadata> getMetadataExpandsConfig(String productId, DeviceMetadataType metadataType, String metadataId, String typeId, ConfigScope ... scopes) {
        return Flux.fromIterable(this.suppliers).flatMap(supplier -> supplier.getMetadataExpandsConfig(productId, metadataType, metadataId, typeId)).sort(Comparator.comparing(ConfigMetadata::getName)).filter(metadata -> metadata.hasAnyScope(scopes)).map(metadata -> metadata.copy(scopes)).filter(meta -> CollectionUtils.isNotEmpty((Collection)meta.getProperties()));
    }

    @Override
    public Flux<ConfigMetadata> getProductConfigMetadataByAccessId(String productId, String accessId) {
        return Flux.fromIterable(this.suppliers).flatMap(supplier -> supplier.getProductConfigMetadataByAccessId(productId, accessId).onErrorResume(e -> {
            log.error("get product config metatada by gateway error", e);
            return Flux.empty();
        })).map(config -> config.copy(new ConfigScope[]{DeviceConfigScope.product})).filter(config -> !org.springframework.util.CollectionUtils.isEmpty((Collection)config.getProperties())).sort(Comparator.comparing(ConfigMetadata::getName));
    }

    @Override
    public Mono<Set<String>> getProductConfigMetadataProperties(String productId) {
        return this.getProductConfigMetadata(productId).flatMapIterable(ConfigMetadata::getProperties).map(ConfigPropertyMetadata::getProperty).collect(Collectors.toSet());
    }

    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        if (bean instanceof DeviceConfigMetadataSupplier) {
            this.register((DeviceConfigMetadataSupplier)bean);
        }
        return bean;
    }

    @Override
    public Flux<Feature> getProductFeatures(String productId) {
        return Flux.fromIterable(this.suppliers).flatMap(supplier -> supplier.getProductFeatures(productId)).distinct(Feature::getId);
    }
}

