/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.response;

import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DeviceInfo {
    private String id;
    private String name;
    private String projectId;
    private String projectName;
    private String classifiedId;
    private String networkWay;
    private String productId;
    private DeviceState state;
    private String creatorId;
    private String creatorName;
    private Long createTime;
    private Long registryTime;
    private String orgId;
    private String describe;
    private String productName;
    private String deviceType;
    private String transportProtocol;
    private String messageProtocol;
    private String deriveMetadata;
    private Map<String, Object> configuration;

    public static DeviceInfo of(DeviceInstanceEntity instance, DeviceProductEntity product) {
        DeviceInfo deviceInfo = (DeviceInfo)FastBeanCopier.copy((Object)((Object)instance), (Object)new DeviceInfo(), (String[])new String[0]);
        deviceInfo.setMessageProtocol(product.getMessageProtocol());
        deviceInfo.setTransportProtocol(product.getTransportProtocol());
        deviceInfo.setDeviceType(product.getDeviceType().getText());
        deviceInfo.setClassifiedId(product.getClassifiedId());
        deviceInfo.setProjectId(product.getProjectId());
        deviceInfo.setProjectName(product.getProjectName());
        deviceInfo.setProductName(product.getName());
        deviceInfo.setNetworkWay(product.getNetworkWay());
        if (CollectionUtils.isEmpty(instance.getConfiguration())) {
            deviceInfo.setConfiguration(product.getConfiguration());
        }
        if (StringUtils.isEmpty((Object)instance.getDeriveMetadata())) {
            deviceInfo.setDeriveMetadata(product.getMetadata());
        }
        return deviceInfo;
    }

    public static DeviceInfoBuilder builder() {
        return new DeviceInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getClassifiedId() {
        return this.classifiedId;
    }

    public String getNetworkWay() {
        return this.networkWay;
    }

    public String getProductId() {
        return this.productId;
    }

    public DeviceState getState() {
        return this.state;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getRegistryTime() {
        return this.registryTime;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public String getMessageProtocol() {
        return this.messageProtocol;
    }

    public String getDeriveMetadata() {
        return this.deriveMetadata;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setClassifiedId(String classifiedId) {
        this.classifiedId = classifiedId;
    }

    public void setNetworkWay(String networkWay) {
        this.networkWay = networkWay;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setRegistryTime(Long registryTime) {
        this.registryTime = registryTime;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public void setMessageProtocol(String messageProtocol) {
        this.messageProtocol = messageProtocol;
    }

    public void setDeriveMetadata(String deriveMetadata) {
        this.deriveMetadata = deriveMetadata;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$registryTime = this.getRegistryTime();
        Long other$registryTime = other.getRegistryTime();
        if (this$registryTime == null ? other$registryTime != null : !((Object)this$registryTime).equals(other$registryTime)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$classifiedId = this.getClassifiedId();
        String other$classifiedId = other.getClassifiedId();
        if (this$classifiedId == null ? other$classifiedId != null : !this$classifiedId.equals(other$classifiedId)) {
            return false;
        }
        String this$networkWay = this.getNetworkWay();
        String other$networkWay = other.getNetworkWay();
        if (this$networkWay == null ? other$networkWay != null : !this$networkWay.equals(other$networkWay)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
            return false;
        }
        DeviceState this$state = this.getState();
        DeviceState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$describe = this.getDescribe();
        String other$describe = other.getDescribe();
        if (this$describe == null ? other$describe != null : !this$describe.equals(other$describe)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$transportProtocol = this.getTransportProtocol();
        String other$transportProtocol = other.getTransportProtocol();
        if (this$transportProtocol == null ? other$transportProtocol != null : !this$transportProtocol.equals(other$transportProtocol)) {
            return false;
        }
        String this$messageProtocol = this.getMessageProtocol();
        String other$messageProtocol = other.getMessageProtocol();
        if (this$messageProtocol == null ? other$messageProtocol != null : !this$messageProtocol.equals(other$messageProtocol)) {
            return false;
        }
        String this$deriveMetadata = this.getDeriveMetadata();
        String other$deriveMetadata = other.getDeriveMetadata();
        if (this$deriveMetadata == null ? other$deriveMetadata != null : !this$deriveMetadata.equals(other$deriveMetadata)) {
            return false;
        }
        Map<String, Object> this$configuration = this.getConfiguration();
        Map<String, Object> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $registryTime = this.getRegistryTime();
        result = result * 59 + ($registryTime == null ? 43 : ((Object)$registryTime).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $classifiedId = this.getClassifiedId();
        result = result * 59 + ($classifiedId == null ? 43 : $classifiedId.hashCode());
        String $networkWay = this.getNetworkWay();
        result = result * 59 + ($networkWay == null ? 43 : $networkWay.hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        DeviceState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $describe = this.getDescribe();
        result = result * 59 + ($describe == null ? 43 : $describe.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $transportProtocol = this.getTransportProtocol();
        result = result * 59 + ($transportProtocol == null ? 43 : $transportProtocol.hashCode());
        String $messageProtocol = this.getMessageProtocol();
        result = result * 59 + ($messageProtocol == null ? 43 : $messageProtocol.hashCode());
        String $deriveMetadata = this.getDeriveMetadata();
        result = result * 59 + ($deriveMetadata == null ? 43 : $deriveMetadata.hashCode());
        Map<String, Object> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceInfo(id=" + this.getId() + ", name=" + this.getName() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", classifiedId=" + this.getClassifiedId() + ", networkWay=" + this.getNetworkWay() + ", productId=" + this.getProductId() + ", state=" + (Object)((Object)this.getState()) + ", creatorId=" + this.getCreatorId() + ", creatorName=" + this.getCreatorName() + ", createTime=" + this.getCreateTime() + ", registryTime=" + this.getRegistryTime() + ", orgId=" + this.getOrgId() + ", describe=" + this.getDescribe() + ", productName=" + this.getProductName() + ", deviceType=" + this.getDeviceType() + ", transportProtocol=" + this.getTransportProtocol() + ", messageProtocol=" + this.getMessageProtocol() + ", deriveMetadata=" + this.getDeriveMetadata() + ", configuration=" + this.getConfiguration() + ")";
    }

    public DeviceInfo(String id, String name, String projectId, String projectName, String classifiedId, String networkWay, String productId, DeviceState state, String creatorId, String creatorName, Long createTime, Long registryTime, String orgId, String describe, String productName, String deviceType, String transportProtocol, String messageProtocol, String deriveMetadata, Map<String, Object> configuration) {
        this.id = id;
        this.name = name;
        this.projectId = projectId;
        this.projectName = projectName;
        this.classifiedId = classifiedId;
        this.networkWay = networkWay;
        this.productId = productId;
        this.state = state;
        this.creatorId = creatorId;
        this.creatorName = creatorName;
        this.createTime = createTime;
        this.registryTime = registryTime;
        this.orgId = orgId;
        this.describe = describe;
        this.productName = productName;
        this.deviceType = deviceType;
        this.transportProtocol = transportProtocol;
        this.messageProtocol = messageProtocol;
        this.deriveMetadata = deriveMetadata;
        this.configuration = configuration;
    }

    public DeviceInfo() {
    }

    public static class DeviceInfoBuilder {
        private String id;
        private String name;
        private String projectId;
        private String projectName;
        private String classifiedId;
        private String networkWay;
        private String productId;
        private DeviceState state;
        private String creatorId;
        private String creatorName;
        private Long createTime;
        private Long registryTime;
        private String orgId;
        private String describe;
        private String productName;
        private String deviceType;
        private String transportProtocol;
        private String messageProtocol;
        private String deriveMetadata;
        private Map<String, Object> configuration;

        DeviceInfoBuilder() {
        }

        public DeviceInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DeviceInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeviceInfoBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public DeviceInfoBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public DeviceInfoBuilder classifiedId(String classifiedId) {
            this.classifiedId = classifiedId;
            return this;
        }

        public DeviceInfoBuilder networkWay(String networkWay) {
            this.networkWay = networkWay;
            return this;
        }

        public DeviceInfoBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public DeviceInfoBuilder state(DeviceState state) {
            this.state = state;
            return this;
        }

        public DeviceInfoBuilder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public DeviceInfoBuilder creatorName(String creatorName) {
            this.creatorName = creatorName;
            return this;
        }

        public DeviceInfoBuilder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public DeviceInfoBuilder registryTime(Long registryTime) {
            this.registryTime = registryTime;
            return this;
        }

        public DeviceInfoBuilder orgId(String orgId) {
            this.orgId = orgId;
            return this;
        }

        public DeviceInfoBuilder describe(String describe) {
            this.describe = describe;
            return this;
        }

        public DeviceInfoBuilder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public DeviceInfoBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DeviceInfoBuilder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public DeviceInfoBuilder messageProtocol(String messageProtocol) {
            this.messageProtocol = messageProtocol;
            return this;
        }

        public DeviceInfoBuilder deriveMetadata(String deriveMetadata) {
            this.deriveMetadata = deriveMetadata;
            return this;
        }

        public DeviceInfoBuilder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this.id, this.name, this.projectId, this.projectName, this.classifiedId, this.networkWay, this.productId, this.state, this.creatorId, this.creatorName, this.createTime, this.registryTime, this.orgId, this.describe, this.productName, this.deviceType, this.transportProtocol, this.messageProtocol, this.deriveMetadata, this.configuration);
        }

        public String toString() {
            return "DeviceInfo.DeviceInfoBuilder(id=" + this.id + ", name=" + this.name + ", projectId=" + this.projectId + ", projectName=" + this.projectName + ", classifiedId=" + this.classifiedId + ", networkWay=" + this.networkWay + ", productId=" + this.productId + ", state=" + (Object)((Object)this.state) + ", creatorId=" + this.creatorId + ", creatorName=" + this.creatorName + ", createTime=" + this.createTime + ", registryTime=" + this.registryTime + ", orgId=" + this.orgId + ", describe=" + this.describe + ", productName=" + this.productName + ", deviceType=" + this.deviceType + ", transportProtocol=" + this.transportProtocol + ", messageProtocol=" + this.messageProtocol + ", deriveMetadata=" + this.deriveMetadata + ", configuration=" + this.configuration + ")";
        }
    }
}

