/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.message.writer;

import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.core.message.DeviceMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class TimeSeriesMessageWriterConnector {
    private static final Logger log = LoggerFactory.getLogger(TimeSeriesMessageWriterConnector.class);
    private final DeviceDataService dataService;

    @Subscribe(topics={"/device/**"}, id="device-message-ts-writer")
    public Mono<Void> writeDeviceMessageToTs(DeviceMessage message) {
        return this.dataService.saveDeviceMessage(message);
    }

    public TimeSeriesMessageWriterConnector(DeviceDataService dataService) {
        this.dataService = dataService;
    }
}

