/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements.message;

import io.micrometer.core.instrument.MeterRegistry;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.dashboard.supports.StaticMeasurementProvider;
import org.jetlinks.community.device.measurements.DeviceDashboardDefinition;
import org.jetlinks.community.device.measurements.DeviceObjectDefinition;
import org.jetlinks.community.device.measurements.message.DeviceMessageMeasurement;
import org.jetlinks.community.device.timeseries.DeviceTimeSeriesMetric;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.micrometer.MeterRegistryManager;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.message.DeviceMessage;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DeviceMessageMeasurementProvider
extends StaticMeasurementProvider {
    MeterRegistry registry;
    static final String[] empty = new String[0];

    public DeviceMessageMeasurementProvider(EventBus eventBus, MeterRegistryManager registryManager, TimeSeriesManager timeSeriesManager) {
        super((DashboardDefinition)DeviceDashboardDefinition.instance, (ObjectDefinition)DeviceObjectDefinition.message);
        this.registry = registryManager.getMeterRegister(DeviceTimeSeriesMetric.deviceMetrics().getId(), new String[]{"target", "msgType", "productId"});
        this.addMeasurement((Measurement)new DeviceMessageMeasurement(eventBus, timeSeriesManager));
    }

    @Subscribe(value={"/device/*/*/message/**"})
    public Mono<Void> incrementMessage(DeviceMessage message) {
        return Mono.fromRunnable(() -> this.registry.counter("message-count", this.convertTags(message)).increment());
    }

    private String[] convertTags(DeviceMessage message) {
        if (message == null) {
            return empty;
        }
        return new String[]{"productId", message.getHeader("productId").map(String::valueOf).orElse("unknown")};
    }
}

