/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DeviceEventsMeasurement
extends StaticMeasurement {
    private final EventBus eventBus;
    private final DeviceDataService deviceDataService;
    private final DeviceMetadata metadata;
    private final String productId;
    static AtomicLong num = new AtomicLong();
    static ConfigMetadata configMetadata = new DefaultConfigMetadata().add("deviceId", "\u8bbe\u5907", "\u6307\u5b9a\u8bbe\u5907", (DataType)new StringType().expand("selector", (Object)"device-selector"));

    public DeviceEventsMeasurement(String productId, EventBus eventBus, DeviceMetadata deviceMetadata, DeviceDataService deviceDataService) {
        super(MeasurementDefinition.of((String)"events", (String)"\u4e8b\u4ef6\u8bb0\u5f55"));
        this.productId = productId;
        this.eventBus = eventBus;
        this.deviceDataService = deviceDataService;
        this.metadata = deviceMetadata;
        this.addDimension(new RealTimeDevicePropertyDimension());
    }

    Flux<SimpleMeasurementValue> fromHistory(String deviceId, int history) {
        return history <= 0 ? Flux.empty() : Flux.fromIterable((Iterable)this.metadata.getEvents()).flatMap(event -> ((Flux)QueryParamEntity.newQuery().doPaging(0, history).execute(q -> this.deviceDataService.queryEvent(deviceId, event.getId(), (QueryParamEntity)q, false))).map(data -> SimpleMeasurementValue.of(this.createValue(event.getId(), data), (long)data.getTimestamp())).sort(MeasurementValue.sort()));
    }

    Map<String, Object> createValue(String event, Object value) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("event", event);
        values.put("data", value);
        return values;
    }

    Flux<MeasurementValue> fromRealTime(String deviceId) {
        Subscription subscription = Subscription.of((String)"realtime-device-events-measurement", (String)("/device/" + this.productId + "/" + deviceId + "/message/event/*"), (Subscription.Feature[])new Subscription.Feature[]{Subscription.Feature.local, Subscription.Feature.broker});
        return this.eventBus.subscribe(subscription, DeviceMessage.class).filter(EventMessage.class::isInstance).cast(EventMessage.class).map(kv -> SimpleMeasurementValue.of(this.createValue(kv.getEvent(), kv.getData()), (long)System.currentTimeMillis()));
    }

    private class RealTimeDevicePropertyDimension
    implements MeasurementDimension {
        private RealTimeDevicePropertyDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.realTime;
        }

        public DataType getValueType() {
            SimplePropertyMetadata property = new SimplePropertyMetadata();
            property.setId("event");
            property.setName("\u4e8b\u4ef6");
            property.setValueType((DataType)new StringType());
            SimplePropertyMetadata value = new SimplePropertyMetadata();
            value.setId("data");
            value.setName("\u6570\u636e");
            value.setValueType((DataType)new StringType());
            return new ObjectType().addPropertyMetadata((PropertyMetadata)property).addPropertyMetadata((PropertyMetadata)value);
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return true;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> {
                int history = parameter.getInt("history").orElse(0);
                return Flux.concat((Publisher[])new Publisher[]{DeviceEventsMeasurement.this.fromHistory((String)deviceId, history), DeviceEventsMeasurement.this.fromRealTime((String)deviceId)});
            });
        }
    }
}

