/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements;

import java.util.Optional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.device.measurements.MetadataMeasurementDefinition;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DeviceEventMeasurement
extends StaticMeasurement {
    public EventMetadata eventMetadata;
    public EventBus eventBus;
    private final DeviceDataService deviceDataService;
    private final String productId;
    static ConfigMetadata configMetadata = new DefaultConfigMetadata().add("deviceId", "\u8bbe\u5907", "\u6307\u5b9a\u8bbe\u5907", (DataType)new StringType().expand("selector", (Object)"device-selector")).add("history", "\u5386\u53f2\u6570\u636e\u91cf", "\u67e5\u8be2\u51fa\u5386\u53f2\u6570\u636e\u540e\u5f00\u59cb\u63a8\u9001\u5b9e\u65f6\u6570\u636e", (DataType)new IntType().min((Number)0).expand("defaultValue", (Object)10));

    public DeviceEventMeasurement(String productId, EventBus eventBus, EventMetadata eventMetadata, DeviceDataService deviceDataService) {
        super((MeasurementDefinition)MetadataMeasurementDefinition.of((Metadata)eventMetadata));
        this.productId = productId;
        this.eventBus = eventBus;
        this.eventMetadata = eventMetadata;
        this.deviceDataService = deviceDataService;
        this.addDimension(new RealTimeDeviceEventDimension());
    }

    Flux<SimpleMeasurementValue> fromHistory(String deviceId, int history) {
        return history <= 0 ? Flux.empty() : ((Flux)((Query)QueryParamEntity.newQuery().doPaging(0, history).where("deviceId", (Object)deviceId)).execute(q -> this.deviceDataService.queryEvent(deviceId, this.eventMetadata.getId(), (QueryParamEntity)q, false))).map(data -> SimpleMeasurementValue.of((Object)data, (long)data.getTimestamp())).sort(MeasurementValue.sort());
    }

    Flux<MeasurementValue> fromRealTime(String deviceId) {
        Subscription subscription = Subscription.of((String)"deviceEventMeasurement", (String)("/device/" + this.productId + "/" + deviceId + "/message/event/" + this.eventMetadata.getId()), (Subscription.Feature[])new Subscription.Feature[]{Subscription.Feature.local});
        return this.eventBus.subscribe(subscription, DeviceMessage.class).cast(EventMessage.class).map(msg -> SimpleMeasurementValue.of((Object)msg.getData(), (long)msg.getTimestamp()));
    }

    class RealTimeDeviceEventDimension
    implements MeasurementDimension {
        RealTimeDeviceEventDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.realTime;
        }

        public DataType getValueType() {
            return DeviceEventMeasurement.this.eventMetadata.getType();
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return true;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> {
                int history = parameter.getInt("history").orElse(0);
                return Flux.concat((Publisher[])new Publisher[]{DeviceEventMeasurement.this.fromHistory((String)deviceId, history), DeviceEventMeasurement.this.fromRealTime((String)deviceId)});
            });
        }
    }
}

