/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.events.handler;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueTypeTranslator {
    private static final Logger log = LoggerFactory.getLogger(ValueTypeTranslator.class);

    private static Object propertyMetadataTranslator(Object value, List<PropertyMetadata> metadataList) {
        if (value instanceof Map) {
            return ValueTypeTranslator.propertyMetadataToMap((Map)value, metadataList);
        }
        return JSON.toJSON((Object)value);
    }

    private static Map<String, Object> propertyMetadataToMap(Map<String, Object> map, List<PropertyMetadata> metadataList) {
        Map<String, PropertyMetadata> metadataMap = ValueTypeTranslator.toMap(metadataList);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            PropertyMetadata property = metadataMap.get(entry.getKey());
            if (null == property) continue;
            entry.setValue(ValueTypeTranslator.translator(entry.getValue(), property.getValueType()));
        }
        return map;
    }

    private static Map<String, PropertyMetadata> toMap(List<PropertyMetadata> metadata) {
        return metadata.stream().collect(Collectors.toMap(Metadata::getId, Function.identity()));
    }

    public static Object translator(Object value, DataType dataType) {
        try {
            if (dataType instanceof DateTimeType) {
                return ((DateTimeType)dataType).convert(value);
            }
            if (dataType instanceof DoubleType) {
                return ((DoubleType)dataType).convert(value);
            }
            if (dataType instanceof FloatType) {
                return ((FloatType)dataType).convert(value);
            }
            if (dataType instanceof LongType) {
                return ((LongType)dataType).convert(value);
            }
            if (dataType instanceof BooleanType) {
                return ((BooleanType)dataType).convert(value);
            }
            if (dataType instanceof IntType) {
                return ((IntType)dataType).convert(value);
            }
            if (dataType instanceof ObjectType) {
                return ValueTypeTranslator.propertyMetadataTranslator(value, ((ObjectType)dataType).getProperties());
            }
            return value;
        }
        catch (Exception e) {
            log.error("\u8bbe\u5907\u4e0a\u62a5\u503c\u4e0e\u5143\u6570\u636e\u503c\u4e0d\u5339\u914d.value:{},DataTypeClass:{}", new Object[]{value, dataType.getClass(), e});
            return value;
        }
    }
}

