/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.entity;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.community.things.data.ThingPropertyDetail;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.UnitSupported;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.GeoPoint;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.unit.ValueUnit;
import org.springframework.util.StringUtils;

public class DeviceProperty
implements Serializable {
    private static final long serialVersionUID = -1L;
    @Schema(description="ID")
    private String id;
    @Schema(description="\u8bbe\u5907ID")
    private String deviceId;
    @Schema(description="\u5c5e\u6027ID")
    private String property;
    @Schema(description="\u5c5e\u6027\u540d")
    private String propertyName;
    @Schema(description="\u7c7b\u578b")
    private String type;
    @Schema(description="\u5355\u4f4d")
    private String unit;
    @Hidden
    private Object numberValue;
    @Hidden
    private Object objectValue;
    @Hidden
    private Date timeValue;
    @Hidden
    private String stringValue;
    @Hidden
    private GeoPoint geoValue;
    @Schema(description="\u5c5e\u6027\u503c")
    private Object value;
    @Schema(description="\u683c\u5f0f\u5316\u503c")
    private Object formatValue;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    private long createTime;
    @Schema(description="\u6570\u636e\u65f6\u95f4")
    private long timestamp;
    @Schema(description="\u683c\u5f0f\u5316\u540e\u7684\u65f6\u95f4,\u5728\u805a\u5408\u67e5\u8be2\u65f6\u6b64\u5b57\u6bb5\u6709\u503c")
    private String formatTime;
    @Schema(description="\u72b6\u6001\u503c")
    private String state;

    public DeviceProperty deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public DeviceProperty property(String property) {
        this.property = property;
        return this;
    }

    public DeviceProperty formatTime(String formatTime) {
        this.formatTime = formatTime;
        return this;
    }

    public DeviceProperty withProperty(PropertyMetadata metadata) {
        if (metadata != null) {
            this.setPropertyName(metadata.getName());
            DataType type = metadata.getValueType();
            Object value = this.getValue();
            try {
                if (type instanceof NumberType) {
                    NumberType numberType = (NumberType)type;
                    Number numberValue = (Number)NumberType.convertScaleNumber((Object)value, (Integer)numberType.getScale(), (RoundingMode)numberType.getRound(), Function.identity());
                    if (numberValue != null) {
                        value = numberValue;
                        this.setValue(value);
                    }
                    this.setNumberValue(numberValue);
                } else if (type instanceof Converter) {
                    value = ((Converter)type).convert(value);
                    this.setValue(value);
                }
                if (type instanceof ObjectType) {
                    this.setObjectValue(value);
                }
                if (type instanceof GeoType && value instanceof GeoPoint) {
                    this.setGeoValue((GeoPoint)value);
                }
                if (type instanceof DateTimeType && value instanceof Date) {
                    this.setTimeValue((Date)value);
                }
                this.setFormatValue(type.format(value));
            }
            catch (Exception numberType) {
                // empty catch block
            }
            if (type instanceof UnitSupported) {
                UnitSupported unitSupported = (UnitSupported)type;
                this.setUnit(Optional.ofNullable(unitSupported.getUnit()).map(ValueUnit::getSymbol).orElse(null));
            }
            this.setType(type.getType());
        }
        return this;
    }

    public static DeviceProperty of(TimeSeriesData data, Object value, PropertyMetadata metadata) {
        DeviceProperty deviceProperty = (DeviceProperty)data.as(DeviceProperty.class);
        deviceProperty.setCreateTime(data.getLong("createTime", data.getTimestamp()));
        deviceProperty.setTimestamp(data.getTimestamp());
        deviceProperty.setValue(value);
        return deviceProperty.withProperty(metadata);
    }

    public static DeviceProperty of(Object value, PropertyMetadata metadata) {
        DeviceProperty property = new DeviceProperty();
        property.setTimestamp(System.currentTimeMillis());
        property.setCreateTime(property.getTimestamp());
        property.setValue(value);
        return property.withProperty(metadata);
    }

    public static DeviceProperty of(AggregationData data, PropertyMetadata metadata) {
        DeviceProperty property = (DeviceProperty)data.as(DeviceProperty.class);
        return property.withProperty(metadata);
    }

    public static DeviceProperty of(TimeSeriesData timeSeriesData, PropertyMetadata metadata) {
        DeviceProperty property = (DeviceProperty)timeSeriesData.as(DeviceProperty.class);
        property.setTimestamp(timeSeriesData.getTimestamp());
        return property.withProperty(metadata);
    }

    public static DeviceProperty of(ThingPropertyDetail detail) {
        DeviceProperty deviceProperty = (DeviceProperty)FastBeanCopier.copy((Object)detail, (Object)new DeviceProperty(), (String[])new String[0]);
        deviceProperty.setDeviceId(detail.getThingId());
        return deviceProperty;
    }

    public DeviceProperty generateId() {
        if (StringUtils.isEmpty((Object)this.id)) {
            this.setId(DigestUtils.md5Hex((String)String.join((CharSequence)"", this.deviceId, this.property, String.valueOf(this.timestamp))));
        }
        return this;
    }

    public static DevicePropertyBuilder builder() {
        return new DevicePropertyBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public Object getNumberValue() {
        return this.numberValue;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public Date getTimeValue() {
        return this.timeValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public GeoPoint getGeoValue() {
        return this.geoValue;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getFormatValue() {
        return this.formatValue;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFormatTime() {
        return this.formatTime;
    }

    public String getState() {
        return this.state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setNumberValue(Object numberValue) {
        this.numberValue = numberValue;
    }

    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public void setTimeValue(Date timeValue) {
        this.timeValue = timeValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setGeoValue(GeoPoint geoValue) {
        this.geoValue = geoValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setFormatValue(Object formatValue) {
        this.formatValue = formatValue;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFormatTime(String formatTime) {
        this.formatTime = formatTime;
    }

    public void setState(String state) {
        this.state = state;
    }

    public DeviceProperty() {
    }

    public DeviceProperty(String id, String deviceId, String property, String propertyName, String type, String unit, Object numberValue, Object objectValue, Date timeValue, String stringValue, GeoPoint geoValue, Object value, Object formatValue, long createTime, long timestamp, String formatTime, String state) {
        this.id = id;
        this.deviceId = deviceId;
        this.property = property;
        this.propertyName = propertyName;
        this.type = type;
        this.unit = unit;
        this.numberValue = numberValue;
        this.objectValue = objectValue;
        this.timeValue = timeValue;
        this.stringValue = stringValue;
        this.geoValue = geoValue;
        this.value = value;
        this.formatValue = formatValue;
        this.createTime = createTime;
        this.timestamp = timestamp;
        this.formatTime = formatTime;
        this.state = state;
    }

    public static class DevicePropertyBuilder {
        private String id;
        private String deviceId;
        private String property;
        private String propertyName;
        private String type;
        private String unit;
        private Object numberValue;
        private Object objectValue;
        private Date timeValue;
        private String stringValue;
        private GeoPoint geoValue;
        private Object value;
        private Object formatValue;
        private long createTime;
        private long timestamp;
        private String formatTime;
        private String state;

        DevicePropertyBuilder() {
        }

        public DevicePropertyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DevicePropertyBuilder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public DevicePropertyBuilder property(String property) {
            this.property = property;
            return this;
        }

        public DevicePropertyBuilder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public DevicePropertyBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DevicePropertyBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public DevicePropertyBuilder numberValue(Object numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public DevicePropertyBuilder objectValue(Object objectValue) {
            this.objectValue = objectValue;
            return this;
        }

        public DevicePropertyBuilder timeValue(Date timeValue) {
            this.timeValue = timeValue;
            return this;
        }

        public DevicePropertyBuilder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public DevicePropertyBuilder geoValue(GeoPoint geoValue) {
            this.geoValue = geoValue;
            return this;
        }

        public DevicePropertyBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public DevicePropertyBuilder formatValue(Object formatValue) {
            this.formatValue = formatValue;
            return this;
        }

        public DevicePropertyBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public DevicePropertyBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DevicePropertyBuilder formatTime(String formatTime) {
            this.formatTime = formatTime;
            return this;
        }

        public DevicePropertyBuilder state(String state) {
            this.state = state;
            return this;
        }

        public DeviceProperty build() {
            return new DeviceProperty(this.id, this.deviceId, this.property, this.propertyName, this.type, this.unit, this.numberValue, this.objectValue, this.timeValue, this.stringValue, this.geoValue, this.value, this.formatValue, this.createTime, this.timestamp, this.formatTime, this.state);
        }

        public String toString() {
            return "DeviceProperty.DevicePropertyBuilder(id=" + this.id + ", deviceId=" + this.deviceId + ", property=" + this.property + ", propertyName=" + this.propertyName + ", type=" + this.type + ", unit=" + this.unit + ", numberValue=" + this.numberValue + ", objectValue=" + this.objectValue + ", timeValue=" + this.timeValue + ", stringValue=" + this.stringValue + ", geoValue=" + this.geoValue + ", value=" + this.value + ", formatValue=" + this.formatValue + ", createTime=" + this.createTime + ", timestamp=" + this.timestamp + ", formatTime=" + this.formatTime + ", state=" + this.state + ")";
        }
    }
}

