/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.entity;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.GeoPoint;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;

public class DevicePropertiesEntity {
    private String id;
    private String deviceId;
    private String property;
    private String propertyName;
    private String stringValue;
    private String formatValue;
    private BigDecimal numberValue;
    private GeoPoint geoValue;
    private long timestamp;
    private Object objectValue;
    private String value;
    private String orgId;
    private String productId;
    private Date timeValue;
    private String type;
    private long createTime;

    public Map<String, Object> toMap() {
        return (Map)FastBeanCopier.copy((Object)this, new HashMap(22), (String[])new String[0]);
    }

    public DevicePropertiesEntity withValue(PropertyMetadata metadata, Object value) {
        if (metadata == null) {
            this.setValue(String.valueOf(value));
            if (value instanceof Number) {
                this.numberValue = new BigDecimal(value.toString());
            } else if (value instanceof Date) {
                this.timeValue = (Date)value;
            }
            return this;
        }
        this.setProperty(metadata.getId());
        this.setPropertyName(metadata.getName());
        return this.withValue(metadata.getValueType(), value);
    }

    public DevicePropertiesEntity withValue(DataType type, Object value) {
        String convertedValue;
        if (value == null) {
            return this;
        }
        this.setType(type.getType());
        if (type instanceof NumberType) {
            NumberType numberType = (NumberType)type;
            Number number = numberType.convertNumber(value);
            if (number == null) {
                throw new UnsupportedOperationException("\u65e0\u6cd5\u5c06" + value + "\u8f6c\u4e3a" + type.getId());
            }
            convertedValue = number.toString();
            BigDecimal numberVal = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof Integer ? BigDecimal.valueOf(number.intValue()) : (number instanceof Long ? BigDecimal.valueOf(number.longValue()) : BigDecimal.valueOf(number.doubleValue())));
            this.setNumberValue(numberVal);
        } else if (type instanceof DateTimeType) {
            DateTimeType dateTimeType = (DateTimeType)type;
            convertedValue = String.valueOf(value);
            this.setTimeValue(dateTimeType.convert(value));
        } else if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            Map val = objectType.convert(value);
            convertedValue = JSON.toJSONString((Object)val);
            this.setObjectValue(val);
        } else if (type instanceof ArrayType) {
            ArrayType objectType = (ArrayType)type;
            List val = objectType.convert(value);
            convertedValue = JSON.toJSONString((Object)val);
            this.setObjectValue(val);
        } else if (type instanceof GeoType) {
            GeoType geoType = (GeoType)type;
            GeoPoint val = geoType.convert(value);
            convertedValue = String.valueOf(val);
            this.setGeoValue(val);
        } else {
            convertedValue = String.valueOf(value);
            this.setStringValue(convertedValue);
        }
        this.setValue(convertedValue);
        Optional.ofNullable(type.format(value)).map(String::valueOf).ifPresent(this::setFormatValue);
        return this;
    }

    public static DevicePropertiesEntityBuilder builder() {
        return new DevicePropertiesEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getFormatValue() {
        return this.formatValue;
    }

    public BigDecimal getNumberValue() {
        return this.numberValue;
    }

    public GeoPoint getGeoValue() {
        return this.geoValue;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getProductId() {
        return this.productId;
    }

    public Date getTimeValue() {
        return this.timeValue;
    }

    public String getType() {
        return this.type;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setFormatValue(String formatValue) {
        this.formatValue = formatValue;
    }

    public void setNumberValue(BigDecimal numberValue) {
        this.numberValue = numberValue;
    }

    public void setGeoValue(GeoPoint geoValue) {
        this.geoValue = geoValue;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setTimeValue(Date timeValue) {
        this.timeValue = timeValue;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public DevicePropertiesEntity() {
    }

    public DevicePropertiesEntity(String id, String deviceId, String property, String propertyName, String stringValue, String formatValue, BigDecimal numberValue, GeoPoint geoValue, long timestamp, Object objectValue, String value, String orgId, String productId, Date timeValue, String type, long createTime) {
        this.id = id;
        this.deviceId = deviceId;
        this.property = property;
        this.propertyName = propertyName;
        this.stringValue = stringValue;
        this.formatValue = formatValue;
        this.numberValue = numberValue;
        this.geoValue = geoValue;
        this.timestamp = timestamp;
        this.objectValue = objectValue;
        this.value = value;
        this.orgId = orgId;
        this.productId = productId;
        this.timeValue = timeValue;
        this.type = type;
        this.createTime = createTime;
    }

    public static class DevicePropertiesEntityBuilder {
        private String id;
        private String deviceId;
        private String property;
        private String propertyName;
        private String stringValue;
        private String formatValue;
        private BigDecimal numberValue;
        private GeoPoint geoValue;
        private long timestamp;
        private Object objectValue;
        private String value;
        private String orgId;
        private String productId;
        private Date timeValue;
        private String type;
        private long createTime;

        DevicePropertiesEntityBuilder() {
        }

        public DevicePropertiesEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DevicePropertiesEntityBuilder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public DevicePropertiesEntityBuilder property(String property) {
            this.property = property;
            return this;
        }

        public DevicePropertiesEntityBuilder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public DevicePropertiesEntityBuilder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public DevicePropertiesEntityBuilder formatValue(String formatValue) {
            this.formatValue = formatValue;
            return this;
        }

        public DevicePropertiesEntityBuilder numberValue(BigDecimal numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public DevicePropertiesEntityBuilder geoValue(GeoPoint geoValue) {
            this.geoValue = geoValue;
            return this;
        }

        public DevicePropertiesEntityBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DevicePropertiesEntityBuilder objectValue(Object objectValue) {
            this.objectValue = objectValue;
            return this;
        }

        public DevicePropertiesEntityBuilder value(String value) {
            this.value = value;
            return this;
        }

        public DevicePropertiesEntityBuilder orgId(String orgId) {
            this.orgId = orgId;
            return this;
        }

        public DevicePropertiesEntityBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public DevicePropertiesEntityBuilder timeValue(Date timeValue) {
            this.timeValue = timeValue;
            return this;
        }

        public DevicePropertiesEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DevicePropertiesEntityBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public DevicePropertiesEntity build() {
            return new DevicePropertiesEntity(this.id, this.deviceId, this.property, this.propertyName, this.stringValue, this.formatValue, this.numberValue, this.geoValue, this.timestamp, this.objectValue, this.value, this.orgId, this.productId, this.timeValue, this.type, this.createTime);
        }

        public String toString() {
            return "DevicePropertiesEntity.DevicePropertiesEntityBuilder(id=" + this.id + ", deviceId=" + this.deviceId + ", property=" + this.property + ", propertyName=" + this.propertyName + ", stringValue=" + this.stringValue + ", formatValue=" + this.formatValue + ", numberValue=" + this.numberValue + ", geoValue=" + this.geoValue + ", timestamp=" + this.timestamp + ", objectValue=" + this.objectValue + ", value=" + this.value + ", orgId=" + this.orgId + ", productId=" + this.productId + ", timeValue=" + this.timeValue + ", type=" + this.type + ", createTime=" + this.createTime + ")";
        }
    }
}

