/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.entity;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.device.enums.DeviceLogType;
import org.jetlinks.community.things.data.ThingMessageLog;
import org.springframework.util.StringUtils;

@Generated
public class DeviceOperationLogEntity {
    private static final long serialVersionUID = -6849794470754667710L;
    @Schema(description="\u65e5\u5fd7ID")
    private String id;
    @Schema(description="\u8bbe\u5907ID")
    private String deviceId;
    @Schema(description="\u4ea7\u54c1ID")
    private String productId;
    @Schema(description="\u65e5\u5fd7\u7c7b\u578b")
    private DeviceLogType type;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    private long createTime;
    @Schema(description="\u65e5\u5fd7\u5185\u5bb9")
    private Object content;
    @Schema(description="\u6d88\u606fID")
    private String messageId;
    @Hidden
    private String orgId;
    @Schema(description="\u6570\u636e\u65f6\u95f4")
    private long timestamp;

    public static DeviceOperationLogEntity of(ThingMessageLog log) {
        DeviceOperationLogEntity messageLog = (DeviceOperationLogEntity)FastBeanCopier.copy((Object)log, (Object)new DeviceOperationLogEntity(), (String[])new String[0]);
        messageLog.setDeviceId(log.getThingId());
        return messageLog;
    }

    public Map<String, Object> toSimpleMap() {
        Map result = (Map)FastBeanCopier.copy((Object)this, HashMap::new, (String[])new String[0]);
        result.put("type", this.type.getValue());
        if (this.content instanceof String) {
            result.put("content", this.content);
        } else {
            result.put("content", JSON.toJSONString((Object)this.getContent()));
        }
        return result;
    }

    public DeviceOperationLogEntity generateId() {
        if (StringUtils.isEmpty((Object)this.id)) {
            this.setId(DigestUtils.md5Hex((String)String.join((CharSequence)"", this.deviceId, this.type.getValue(), String.valueOf(this.timestamp))));
        }
        return this;
    }

    public static DeviceOperationLogEntityBuilder builder() {
        return new DeviceOperationLogEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getProductId() {
        return this.productId;
    }

    public DeviceLogType getType() {
        return this.type;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Object getContent() {
        return this.content;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setType(DeviceLogType type) {
        this.type = type;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceOperationLogEntity)) {
            return false;
        }
        DeviceOperationLogEntity other = (DeviceOperationLogEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
            return false;
        }
        DeviceLogType this$type = this.getType();
        DeviceLogType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        return !(this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceOperationLogEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        DeviceLogType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceOperationLogEntity(id=" + this.getId() + ", deviceId=" + this.getDeviceId() + ", productId=" + this.getProductId() + ", type=" + (Object)((Object)this.getType()) + ", createTime=" + this.getCreateTime() + ", content=" + this.getContent() + ", messageId=" + this.getMessageId() + ", orgId=" + this.getOrgId() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public DeviceOperationLogEntity(String id, String deviceId, String productId, DeviceLogType type, long createTime, Object content, String messageId, String orgId, long timestamp) {
        this.id = id;
        this.deviceId = deviceId;
        this.productId = productId;
        this.type = type;
        this.createTime = createTime;
        this.content = content;
        this.messageId = messageId;
        this.orgId = orgId;
        this.timestamp = timestamp;
    }

    public DeviceOperationLogEntity() {
    }

    public static class DeviceOperationLogEntityBuilder {
        private String id;
        private String deviceId;
        private String productId;
        private DeviceLogType type;
        private long createTime;
        private Object content;
        private String messageId;
        private String orgId;
        private long timestamp;

        DeviceOperationLogEntityBuilder() {
        }

        public DeviceOperationLogEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DeviceOperationLogEntityBuilder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public DeviceOperationLogEntityBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public DeviceOperationLogEntityBuilder type(DeviceLogType type) {
            this.type = type;
            return this;
        }

        public DeviceOperationLogEntityBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public DeviceOperationLogEntityBuilder content(Object content) {
            this.content = content;
            return this;
        }

        public DeviceOperationLogEntityBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public DeviceOperationLogEntityBuilder orgId(String orgId) {
            this.orgId = orgId;
            return this;
        }

        public DeviceOperationLogEntityBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DeviceOperationLogEntity build() {
            return new DeviceOperationLogEntity(this.id, this.deviceId, this.productId, this.type, this.createTime, this.content, this.messageId, this.orgId, this.timestamp);
        }

        public String toString() {
            return "DeviceOperationLogEntity.DeviceOperationLogEntityBuilder(id=" + this.id + ", deviceId=" + this.deviceId + ", productId=" + this.productId + ", type=" + (Object)((Object)this.type) + ", createTime=" + this.createTime + ", content=" + this.content + ", messageId=" + this.messageId + ", orgId=" + this.orgId + ", timestamp=" + this.timestamp + ")";
        }
    }
}

