package net.zstong.awump.monitoring.service;


import net.zstong.awump.base.entity.AwInstitutionEntity;
import net.zstong.awump.base.entity.AwRegionEntity;
import net.zstong.awump.monitoring.entity.AwMonitoringAreaEntity;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.GenericReactiveTreeSupportCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;


import java.util.List;


@Service
public class AwMonitoringAreaService extends GenericReactiveTreeSupportCrudService<AwMonitoringAreaEntity, String> {

    @Override
    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    @Override
    public void setChildren(AwMonitoringAreaEntity entity, List<AwMonitoringAreaEntity> children) {
        entity.setChildren(children);
    }


    public Flux<AwMonitoringAreaEntity> getAllCategoryTreeByQueryParam(Mono<QueryParamEntity> query) {
        return this
            .query(query)
            .collectList()
            .flatMapMany(all -> {
                List<AwMonitoringAreaEntity> t = TreeSupportEntity.list2tree(all, AwMonitoringAreaEntity::setChildren);
                return Flux.fromIterable(t);
            });
    }


}
