package net.zstong.awump.inspection.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.BaseEntity;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
* @author yuanhc
* @date 2023-07-01
*/
@Getter
@Setter
@Table(name="aw_inspection_plan_dev")
@Comment("巡检计划设备")
@EnableEntityEvent
public class AwInspectionPlanDevEntity extends BaseEntity<String> {



    /** 所属计划 */
    @Schema(description = "所属计划")
    @Column(name = "plan_id_",length =64 )
    private String planId;


    /** 设备类型 */
    @Schema(description = "设备类型")
    @Column(name = "device_type_",length =64 )
    private String deviceType;


    /** 设备名称 */
    @Schema(description = "设备名称")
    @Column(name = "name_",length =256 )
    private String name;


    /** 设备ID */
    @Schema(description = "设备ID")
    @Column(name = "device_id_",length =64 )
    private String deviceId;


    /** 设备编码 */
    @Schema(description = "设备编码")
    @Column(name = "code_",length =64 )
    private String code;


    /** 巡检时间 */
    @Schema(description = "巡检时间")
    @Column(name = "inspection_date_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime inspectionDate;


    /** 设备位置 */
    @Schema(description = "设备位置")
    @Column(name = "location_",length =200 )
    private String location;


    /** 巡检情况 */
    @Schema(description = "巡检情况")
    @Column(name = "reslut_",length =200 )
    private String reslut;


    /** 设备状态 */
    @Schema(description = "设备状态")
    @Column(name = "status_",length =32 )
    private String status;


    /** 描述 */
    @Schema(description = "描述")
    @Column(name = "describe_",length =200 )
    private String describe;











}