package net.zstong.awump.device.web.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.jetlinks.community.device.enums.DeviceState;

import java.util.List;

/**
 * the client user type
 *
 * @author felord.cn
 */
@Data
@AllArgsConstructor
public class CountDeviceData {
    private String warehouse;
    private String warehouseName;
    private String state;
    private Integer total;
    public List<CountDeviceData> detail;

    public String getStateName() {
        if (state == null) {
            return "";
        }
        return DeviceState.valueOf(this.state).getText();
    }

    public int getColorIdx() {
        if (state == null) {
            return 0;
        }
        if (DeviceState.notActive.name().equals(this.state)) {
            return 2;
        } else if (DeviceState.offline.name().equals(this.state)) {
            return 1;
        } else {
            return 0;
        }
    }

}
