package net.zstong.awump.base.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import net.zstong.awump.base.entity.AwInstitutionEntity;
import net.zstong.awump.base.entity.AwIntensiveFrameInfo;
import net.zstong.awump.base.entity.AwWarehouseEntity;
import net.zstong.awump.base.entity.AwWarehouseInfo;
import net.zstong.awump.base.service.AwInstitutionService;
import net.zstong.awump.base.service.AwWarehouseService;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping({"/aw/base/warehouse"})
@Resource(id = "aw-base-warehouse", name = "库房管理接口")
@Tag(name = "库房管理接口")
@Slf4j
public class AwWarehouseController implements ReactiveServiceCrudController<AwWarehouseEntity, String> {

    @Autowired
    private AwWarehouseService awWarehouseService;

    @Override
    public ReactiveCrudService<AwWarehouseEntity, String> getService() {
        return awWarehouseService;
    }

    @PostMapping("/info/_query")
    @QueryAction
    @Operation(summary = "分页查询仓库带相关信息详情")
    public Mono<PagerResult<AwWarehouseInfo>> queryInstitution(@RequestBody Mono<QueryParamEntity> paramBody) {
        return awWarehouseService.queryInfo(paramBody);
    }

}
