package net.zstong.awump.base.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

/**
 * @author yuanhc
 * @date 2023-05-26
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class AwWarehouseInfo extends BaseEntity<String> {


    /**
     * 所属区域
     */
    @Schema(description = "所属区域")
    private String regionId;

    private AwRegionEntity region;

    /**
     * 所属单位
     */
    @Schema(description = "所属单位")
    private String institutionId;

    private AwInstitutionInfo institution;


    /**
     * 库房名称
     */
    @Schema(description = "库房名称")
    private String name;


    /**
     * 库房编码
     */
    @Schema(description = "库房编码")
    private String code;


    /**
     * 类型
     */
    @Schema(description = "类型")
    private String warehouseType;


    /**
     * 描述
     */
    @Schema(description = "描述")
    private String describe;


    public static AwWarehouseInfo of(AwWarehouseEntity entity) {
        AwWarehouseInfo info = new AwWarehouseInfo();
        BeanUtils.copyProperties(entity, info);
        return info;
    }


}