/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.supports;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.dashboard.Dashboard;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.DashboardManager;
import org.jetlinks.community.dashboard.supports.CompositeDashboard;
import org.jetlinks.community.dashboard.supports.MeasurementProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DefaultDashboardManager
implements DashboardManager,
BeanPostProcessor {
    private Map<String, CompositeDashboard> dashboards = new ConcurrentHashMap<String, CompositeDashboard>();

    @Override
    public Flux<Dashboard> getDashboards() {
        return Flux.fromIterable(this.dashboards.values());
    }

    @Override
    public Mono<Dashboard> getDashboard(String id) {
        return Mono.justOrEmpty((Object)this.dashboards.get(id));
    }

    private void addProvider(MeasurementProvider provider) {
        DashboardDefinition definition = provider.getDashboardDefinition();
        CompositeDashboard dashboard = this.dashboards.computeIfAbsent(definition.getId(), __ -> new CompositeDashboard(definition));
        dashboard.addProvider(provider);
    }

    private void addDashboard(Dashboard dashboard) {
        CompositeDashboard cached = this.dashboards.computeIfAbsent(dashboard.getDefinition().getId(), __ -> new CompositeDashboard(dashboard.getDefinition()));
        cached.addDashboard(dashboard);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MeasurementProvider) {
            this.addProvider((MeasurementProvider)bean);
        } else if (bean instanceof Dashboard) {
            this.addDashboard((Dashboard)bean);
        }
        return bean;
    }
}

