/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.measurements.sys;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.CommonMeasurementDefinition;
import org.jetlinks.community.dashboard.DefaultDashboardDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.measurements.MonitorObjectDefinition;
import org.jetlinks.community.dashboard.measurements.sys.MonitorInfo;
import org.jetlinks.community.dashboard.measurements.sys.SystemMonitorService;
import org.jetlinks.community.dashboard.measurements.sys.SystemMonitorServiceImpl;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.dashboard.supports.StaticMeasurementProvider;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class SystemMonitorMeasurementProvider
extends StaticMeasurementProvider {
    private final SystemMonitorService monitorService = new SystemMonitorServiceImpl();

    public SystemMonitorMeasurementProvider() {
        super(DefaultDashboardDefinition.systemMonitor, MonitorObjectDefinition.stats);
        this.addMeasurement(new StaticMeasurement(CommonMeasurementDefinition.info).addDimension(new RealTimeDimension()));
    }

    private void putTo(String prefix, MonitorInfo<?> source, Map<String, Object> target) {
        Map data = (Map)FastBeanCopier.copy(source, new HashMap(), (String[])new String[0]);
        data.forEach((key, value) -> {
            char[] keyChars = key.toCharArray();
            keyChars[0] = Character.toUpperCase(keyChars[0]);
            target.put(prefix + new String(keyChars), value);
        });
    }

    class RealTimeDimension
    implements MeasurementDimension {
        RealTimeDimension() {
        }

        @Override
        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.realTime;
        }

        @Override
        public DataType getValueType() {
            return new ObjectType();
        }

        @Override
        public ConfigMetadata getParams() {
            return new DefaultConfigMetadata().add("serverNodeId", "\u670d\u52a1\u8282\u70b9ID", (DataType)StringType.GLOBAL).add("interval", "\u66f4\u65b0\u9891\u7387", (DataType)StringType.GLOBAL).add("type", "\u6307\u6807\u7c7b\u578b", (DataType)new EnumType().addElement(EnumType.Element.of((String)"all", (String)"\u5168\u90e8")).addElement(EnumType.Element.of((String)"cpu", (String)"CPU")).addElement(EnumType.Element.of((String)"memory", (String)"\u5185\u5b58")).addElement(EnumType.Element.of((String)"disk", (String)"\u786c\u76d8")));
        }

        @Override
        public boolean isRealTime() {
            return true;
        }

        public Publisher<? extends MeasurementValue> getValue(MeasurementParameter parameter) {
            Duration interval = parameter.getDuration("interval", Duration.ofSeconds(1L));
            String type = parameter.getString("type", "all");
            return Flux.concat((Publisher[])new Publisher[]{this.info(SystemMonitorMeasurementProvider.this.monitorService, type), Flux.interval((Duration)interval).flatMap(ignore -> this.info(SystemMonitorMeasurementProvider.this.monitorService, type))}).map(info -> SimpleMeasurementValue.of(info, System.currentTimeMillis()));
        }

        private Mono<? extends MonitorInfo<?>> info(SystemMonitorService service, String type) {
            Object data;
            switch (type) {
                case "cpu": {
                    data = service.cpu();
                    break;
                }
                case "memory": {
                    data = service.memory();
                    break;
                }
                case "disk": {
                    data = service.disk();
                    break;
                }
                default: {
                    data = service.system();
                }
            }
            return data.onErrorResume(err -> Mono.empty());
        }
    }
}

