/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor.device;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProviders;
import org.jetlinks.community.rule.engine.executor.device.SelectorValue;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.metadata.DeviceMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeviceSelectorSpec
extends VariableSource {
    @Schema(description="\u9009\u62e9\u5668\u6807\u8bc6")
    @NotBlank
    private String selector;
    @Schema(description="\u9009\u62e9\u5668\u7684\u503c,\u5982\u9009\u62e9\u7684\u90e8\u95e8ID,\u6807\u7b7e\u4fe1\u606f\u7b49")
    private List<SelectorValue> selectorValues;

    @Schema(description="\u56fa\u5b9a\u8bbe\u5907ID")
    public Object getValue() {
        return super.getValue();
    }

    public DeviceSelectorSpec() {
    }

    private DeviceSelectorSpec(String selector, List<SelectorValue> selectorValue) {
        this.selector = selector;
        super.setValue(selectorValue);
    }

    public static DeviceSelectorSpec selector(@NotNull String selector, List<SelectorValue> selectorValue) {
        return new DeviceSelectorSpec(selector, selectorValue);
    }

    public Flux<Object> resolveSelectorValues(Map<String, Object> context) {
        if (CollectionUtils.isNotEmpty(this.selectorValues)) {
            return Flux.fromIterable(this.selectorValues).mapNotNull(SelectorValue::getValue);
        }
        return super.resolve(context);
    }

    public void validate() {
        DeviceSelectorProviders.getProviderNow(this.selector);
    }

    public Mono<DeviceMetadata> getDeviceMetadata(DeviceRegistry registry, String productId) {
        List<SelectorValue> fixed;
        if (this.getSource() == VariableSource.Source.fixed && CollectionUtils.isNotEmpty(fixed = this.getSelectorValues()) && fixed.size() == 1) {
            return registry.getDevice(String.valueOf(fixed.get(0).getValue())).flatMap(DeviceOperator::getMetadata);
        }
        return registry.getProduct(productId).flatMap(DeviceProductOperator::getMetadata);
    }

    public String getSelector() {
        return this.selector;
    }

    public List<SelectorValue> getSelectorValues() {
        return this.selectorValues;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setSelectorValues(List<SelectorValue> selectorValues) {
        this.selectorValues = selectorValues;
    }
}

