/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.server.vertx;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.http.server.HttpExchange;
import org.jetlinks.community.network.http.server.HttpServer;
import org.jetlinks.community.network.http.server.WebSocketExchange;
import org.jetlinks.community.network.http.server.vertx.HttpServerConfig;
import org.jetlinks.community.network.http.server.vertx.VertxHttpExchange;
import org.jetlinks.community.network.http.server.vertx.VertxWebSocketExchange;
import org.jetlinks.core.topic.Topic;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class VertxHttpServer
implements HttpServer {
    private static final Logger log = LoggerFactory.getLogger(VertxHttpServer.class);
    private Collection<io.vertx.core.http.HttpServer> httpServers;
    private HttpServerConfig config;
    private String id;
    private final Topic<FluxSink<HttpExchange>> route = Topic.createRoot();
    private final Topic<FluxSink<WebSocketExchange>> websocketRoute = Topic.createRoot();
    private String lastError;
    private InetSocketAddress bindAddress;

    public VertxHttpServer(HttpServerConfig config) {
        this.config = config;
        this.id = config.getId();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setHttpServers(Collection<io.vertx.core.http.HttpServer> httpServers) {
        if (this.isAlive()) {
            this.shutdown();
        }
        this.httpServers = httpServers;
        for (io.vertx.core.http.HttpServer server : this.httpServers) {
            server.webSocketHandler(socket -> {
                socket.exceptionHandler(err -> log.error(err.getMessage(), err));
                String url = socket.path();
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                VertxWebSocketExchange exchange = new VertxWebSocketExchange((ServerWebSocket)socket);
                this.websocketRoute.findTopic("/ws" + url).flatMapIterable(Topic::getSubscribers).doOnNext(sink -> sink.next((Object)exchange)).switchIfEmpty((Publisher)Mono.fromRunnable(() -> {
                    log.warn("http server no handler for:[{}://{}{}]", new Object[]{socket.scheme(), socket.host(), socket.path()});
                    socket.reject(404);
                })).subscribe();
            }).requestHandler(request -> {
                request.exceptionHandler(err -> log.error(err.getMessage(), err));
                VertxHttpExchange exchange = new VertxHttpExchange((HttpServerRequest)request, this.config);
                String url = exchange.getUrl();
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                this.route.findTopic("/" + exchange.request().getMethod().name().toLowerCase() + url).flatMapIterable(Topic::getSubscribers).doOnNext(sink -> sink.next((Object)exchange)).switchIfEmpty((Publisher)Mono.fromRunnable(() -> {
                    log.warn("http server no handler for:[{} {}://{}{}]", new Object[]{request.method(), request.scheme(), request.host(), request.path()});
                    request.response().setStatusCode(HttpStatus.NOT_FOUND.value()).end();
                })).subscribe();
            });
            server.exceptionHandler(err -> log.error(err.getMessage(), err));
        }
    }

    @Override
    public Flux<HttpExchange> handleRequest() {
        return this.handleRequest("*", "/**");
    }

    @Override
    public Flux<WebSocketExchange> handleWebsocket(String urlPattern) {
        return this.createRoute(this.websocketRoute, "ws", urlPattern);
    }

    @Override
    public Flux<HttpExchange> handleRequest(String method, String ... urlPatterns) {
        return this.createRoute(this.route, method, urlPatterns);
    }

    private <T> Flux<T> createRoute(Topic<FluxSink<T>> root, String prefix, String ... urlPatterns) {
        return Flux.create(sink -> {
            Disposable.Composite disposable = Disposables.composite();
            for (String urlPattern : urlPatterns) {
                String pattern = Stream.of(urlPattern.split("/")).map(str -> {
                    if (str.startsWith("{") && str.endsWith("}")) {
                        return "*";
                    }
                    return str;
                }).collect(Collectors.joining("/"));
                if (pattern.endsWith("/")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                if (!pattern.startsWith("/")) {
                    pattern = "/".concat(pattern);
                }
                pattern = "/" + prefix + pattern;
                log.debug("handle http request : {}", (Object)pattern);
                Topic sub = root.append(pattern);
                sub.subscribe((Object[])new FluxSink[]{sink});
                disposable.add(() -> sub.unsubscribe((Object[])new FluxSink[]{sink}));
            }
            sink.onDispose((Disposable)disposable);
        });
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public NetworkType getType() {
        return DefaultNetworkType.HTTP_SERVER;
    }

    @Override
    public void shutdown() {
        if (this.httpServers != null) {
            for (io.vertx.core.http.HttpServer httpServer : this.httpServers) {
                httpServer.close(res -> {
                    if (res.failed()) {
                        log.error(res.cause().getMessage(), res.cause());
                    } else {
                        log.debug("http server [{}] closed", (Object)httpServer.actualPort());
                    }
                });
            }
            this.httpServers.clear();
            this.httpServers = null;
        }
    }

    public boolean isAlive() {
        return this.httpServers != null && !this.httpServers.isEmpty();
    }

    public boolean isAutoReload() {
        return false;
    }

    public void setConfig(HttpServerConfig config) {
        this.config = config;
    }

    public void setId(String id) {
        this.id = id;
    }

    public VertxHttpServer(Collection<io.vertx.core.http.HttpServer> httpServers, HttpServerConfig config, String id, String lastError, InetSocketAddress bindAddress) {
        this.httpServers = httpServers;
        this.config = config;
        this.id = id;
        this.lastError = lastError;
        this.bindAddress = bindAddress;
    }

    public VertxHttpServer() {
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }
}

