/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.device;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.jetlinks.community.network.http.server.WebSocketExchange;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.codec.http.websocket.DefaultWebSocketMessage;
import org.jetlinks.core.message.codec.http.websocket.WebSocketMessage;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

class WebSocketDeviceSession
implements DeviceSession {
    private volatile DeviceOperator operator;
    private WebSocketExchange exchange;
    private final long connectTime = System.currentTimeMillis();
    private Duration keepAliveTimeout;

    public WebSocketDeviceSession(DeviceOperator device, WebSocketExchange exchange) {
        this.operator = device;
        this.exchange = exchange;
    }

    public String getId() {
        return this.getDeviceId();
    }

    public String getDeviceId() {
        return this.operator == null ? "unknown" : this.operator.getDeviceId();
    }

    public long lastPingTime() {
        return this.exchange.getLastKeepAliveTime();
    }

    public long connectTime() {
        return this.connectTime;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        if (encodedMessage instanceof WebSocketMessage) {
            return this.exchange.send((WebSocketMessage)encodedMessage).thenReturn((Object)true);
        }
        return this.exchange.send((WebSocketMessage)DefaultWebSocketMessage.of((WebSocketMessage.Type)WebSocketMessage.Type.TEXT, (ByteBuf)encodedMessage.getPayload())).thenReturn((Object)true);
    }

    public Transport getTransport() {
        return DefaultTransport.WebSocket;
    }

    public void close() {
        this.exchange.close().subscribe();
    }

    public void ping() {
    }

    public boolean isAlive() {
        return this.exchange.isAlive();
    }

    public void onClose(Runnable call) {
        this.exchange.closeHandler(call);
    }

    public InetSocketAddress getAddress() {
        return this.exchange.getRemoteAddress().orElse(null);
    }

    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeout = timeout;
        this.exchange.setKeepAliveTimeout(timeout);
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public WebSocketDeviceSession copy() {
        WebSocketDeviceSession session = new WebSocketDeviceSession(this.operator, this.exchange);
        session.setKeepAliveTimeout(this.keepAliveTimeout);
        return session;
    }

    public WebSocketDeviceSession(DeviceOperator operator, WebSocketExchange exchange, Duration keepAliveTimeout) {
        this.operator = operator;
        this.exchange = exchange;
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public DeviceOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DeviceOperator operator) {
        this.operator = operator;
    }

    public void setExchange(WebSocketExchange exchange) {
        this.exchange = exchange;
    }
}

