"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.subjectCase = void 0;
const ensure_1 = require("@commitlint/ensure");
const message_1 = __importDefault(require("@commitlint/message"));
const negated = (when) => when === 'never';
const subjectCase = (parsed, when = 'always', value = []) => {
    const { subject } = parsed;
    if (typeof subject !== 'string' || !subject.match(/^[a-z]/i)) {
        return [true];
    }
    const checks = (Array.isArray(value) ? value : [value]).map((check) => {
        if (typeof check === 'string') {
            return {
                when: 'always',
                case: check,
            };
        }
        return check;
    });
    const result = checks.some((check) => {
        const r = (0, ensure_1.case)(subject, check.case);
        return negated(check.when) ? !r : r;
    });
    const list = checks.map((c) => c.case).join(', ');
    return [
        negated(when) ? !result : result,
        (0, message_1.default)([`subject must`, negated(when) ? `not` : null, `be ${list}`]),
    ];
};
exports.subjectCase = subjectCase;
//# sourceMappingURL=subject-case.js.map