/* Analyzed bindings: {
  "Tabs": "setup-maybe-ref",
  "tabsProps": "setup-maybe-ref",
  "useSlots": "setup-const",
  "ref": "setup-const",
  "onMounted": "setup-const",
  "nextTick": "setup-const",
  "watch": "setup-const",
  "useElementSize": "setup-maybe-ref",
  "slots": "setup-maybe-ref",
  "renderArr": "setup-maybe-ref",
  "props": "setup-reactive-const",
  "jetTabs": "setup-ref",
  "content": "setup-ref",
  "centerExtraWidth": "setup-ref",
  "width": "setup-maybe-ref"
} */
import { defineComponent as _defineComponent } from 'vue';
import { unref as _unref, renderSlot as _renderSlot, normalizeProps as _normalizeProps, guardReactiveProps as _guardReactiveProps, withCtx as _withCtx, renderList as _renderList, createSlots as _createSlots, createVNode as _createVNode, normalizeStyle as _normalizeStyle, createElementVNode as _createElementVNode, Teleport as _Teleport, openBlock as _openBlock, createBlock as _createBlock, createCommentVNode as _createCommentVNode, createElementBlock as _createElementBlock } from "vue";
import { Tabs } from 'ant-design-vue';
import { tabsProps } from './tabsTypes';
import { useSlots, ref, watch } from 'vue';
import { useElementSize } from '@vueuse/core';
const __sfc_main__ = /*#__PURE__*/ _defineComponent({
    props: tabsProps,
    setup(__props) {
        const props = __props;
        const slots = useSlots();
        const renderArr = Object.keys(slots).filter((item) => !['centerExtra'].includes(item));
        const jetTabs = ref();
        const content = ref();
        const centerExtraWidth = ref();
        const { width } = useElementSize(jetTabs);
        watch(width, () => {
            if (jetTabs.value) {
                centerExtraWidth.value =
                    jetTabs.value.querySelector('.ant-tabs-nav-wrap').clientWidth -
                        jetTabs.value.querySelector('.ant-tabs-nav-list').clientWidth -
                        10 +
                        'px';
                content.value = jetTabs.value.querySelector('.ant-tabs-nav-wrap');
            }
        }, { immediate: true });
        return (_ctx, _cache) => {
            return (_openBlock(), _createElementBlock("div", {
                ref_key: "jetTabs",
                ref: jetTabs,
                class: "jet-tabs"
            }, [
                _createVNode(_unref(Tabs), _normalizeProps(_guardReactiveProps(props)), _createSlots({ _: 2 /* DYNAMIC */ }, [
                    _renderList(_unref(renderArr), (item) => {
                        return {
                            name: item,
                            fn: _withCtx((scope) => [
                                _renderSlot(_ctx.$slots, item, { scope: scope })
                            ])
                        };
                    })
                ]), 1040 /* FULL_PROPS, DYNAMIC_SLOTS */),
                (content.value)
                    ? (_openBlock(), _createBlock(_Teleport, {
                        key: 0,
                        to: content.value
                    }, [
                        _createElementVNode("div", {
                            class: "center-extra-content",
                            style: _normalizeStyle({ width: centerExtraWidth.value })
                        }, [
                            _renderSlot(_ctx.$slots, "centerExtra")
                        ], 4 /* STYLE */)
                    ], 8 /* PROPS */, ["to"]))
                    : _createCommentVNode("v-if", true)
            ], 512 /* NEED_PATCH */));
        };
    }
});
export default __sfc_main__;