/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.manager.PropertiesService;
import com.artfess.uc.model.Properties;
import com.artfess.uc.params.properties.PropertiesVo;
import com.artfess.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/properties/v1/"})
@Api(tags={"\u7cfb\u7edf\u53c2\u6570"})
@ApiGroup(group={"group_uc"})
public class PropertiesController
extends BaseController<PropertiesService, Properties> {
    @Resource
    PropertiesService propertiesService;

    @RequestMapping(value={"properties/getPropertiesPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5217\u8868")
    public PageList<Properties> getPropertiesPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        return this.propertiesService.query(filter);
    }

    @RequestMapping(value={"properties/getPropertiesList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7cfb\u7edf\u53c2\u6570", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7cfb\u7edf\u53c2\u6570")
    public List<Properties> getPropertiesList(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        if (BeanUtils.isEmpty((Object)filter)) {
            filter = QueryFilter.build();
        }
        filter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(10000)));
        return this.propertiesService.query(filter).getRows();
    }

    @RequestMapping(value={"properties/updateProperties"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u53c2\u6570", httpMethod="PUT", notes="\u66f4\u65b0\u7cfb\u7edf\u53c2\u6570")
    @UpdateMethod(type=PropertiesVo.class)
    public CommonResult<String> updateProperties(@ApiParam(name="Properties", value="\u7cfb\u7edf\u53c2\u6570\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody PropertiesVo Properties2) throws Exception {
        return this.propertiesService.updateProperties(Properties2);
    }

    @RequestMapping(value={"properties/getProperties"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f")
    public Properties getProperties(@ApiParam(name="code", value="\u7cfb\u7edf\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.propertiesService.getPropertiesByCode(code);
    }
}

