import * as formatUtil from '../../util/format';
import ComponentView from '../../view/Component';
import { CallbackDataParams, ECElement, CommonTooltipOption } from '../../util/types';
import GlobalModel from '../../model/Global';
import ExtensionAPI from '../../core/ExtensionAPI';
import TooltipModel, { TooltipOption } from './TooltipModel';
import { DataByCoordSys } from '../axisPointer/axisTrigger';
interface ShowTipPayload {
    type?: 'showTip';
    from?: string;
    tooltip?: ECElement['tooltip'];
    dataByCoordSys?: DataByCoordSys[];
    tooltipOption?: CommonTooltipOption<TooltipCallbackDataParams | TooltipCallbackDataParams[]>;
    seriesIndex?: number;
    dataIndex?: number;
    x?: number;
    y?: number;
    position?: TooltipOption['position'];
    dispatchAction?: ExtensionAPI['dispatchAction'];
}
interface HideTipPayload {
    type?: 'hideTip';
    from?: string;
    dispatchAction?: ExtensionAPI['dispatchAction'];
}
declare type TooltipCallbackDataParams = CallbackDataParams & {
    axisDim?: string;
    axisIndex?: number;
    axisType?: string;
    axisId?: string;
    axisValue?: string | number;
    axisValueLabel?: string;
    marker?: formatUtil.TooltipMarker;
};
declare class TooltipView extends ComponentView {
    static type: "tooltip";
    type: "tooltip";
    private _renderMode;
    private _tooltipModel;
    private _ecModel;
    private _api;
    private _alwaysShowContent;
    private _tooltipContent;
    private _refreshUpdateTimeout;
    private _lastX;
    private _lastY;
    private _ticket;
    private _showTimout;
    private _lastDataByCoordSys;
    init(ecModel: GlobalModel, api: ExtensionAPI): void;
    render(tooltipModel: TooltipModel, ecModel: GlobalModel, api: ExtensionAPI): void;
    private _initGlobalListener;
    private _keepShow;
    manuallyShowTip(tooltipModel: TooltipModel, ecModel: GlobalModel, api: ExtensionAPI, payload: ShowTipPayload): void;
    manuallyHideTip(tooltipModel: TooltipModel, ecModel: GlobalModel, api: ExtensionAPI, payload: HideTipPayload): void;
    private _manuallyAxisShowTip;
    private _tryShow;
    private _showOrMove;
    private _showAxisTooltip;
    private _showSeriesItemTooltip;
    private _showComponentItemTooltip;
    private _showTooltipContent;
    private _getNearestPoint;
    private _updatePosition;
    private _updateContentNotChangedOnAxis;
    private _hide;
    dispose(ecModel: GlobalModel, api: ExtensionAPI): void;
}
export default TooltipView;
