/**
 * 删除存储信息。
 *
 * \ **API目录**：设备
 *
 * @apiName 删除存储信息
 *
 * @param name string 是 存储信息的key值
 *
 * @returns
 * value string 存储信息的value值
 *
 * @support
 *  - IOS v1.3.1.1
 *  - Android v1.3.1.1
 *
 * @example
 * ```typescript
 * removeStorageItem({
 *    name: '1233123213'
 * })
 *   .then(res => {
 *     console.log(res);
 *   })
 *   .catch(err => {
 *     console.log(err);
 *   });
 * ```
 */
declare function removeStorageItem(args: {
    name: string;
}): Promise<{
    value: string;
}>;
declare namespace removeStorageItem {
    var version: {
        android: string;
        ios: string;
    };
}
export default removeStorageItem;
