import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '联系人',
            prop: 'companyContact',
            type: 'input',
            value: ''
        },
        {
            title: '联系电话',
            prop: 'contactTel',
            type: 'input',
            value: ''
        },
        {
            title: '注册日期',
            prop: 'companyRegdate',
            type: 'date',
            dateOption: {
                type: 'daterange',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '签署状态',
            prop: 'auditStatus',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('qyxyqszt'),
            value: []
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'companyCode',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '创建人',
            prop: 'createUserName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '变更状态',
            prop: 'status',
            type: 'select',
            multiple: true,
            options: [
                { name: '否', value: '0' },
                { name: '是', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '创建时间',
            prop: 'createTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '变更原因',
            prop: 'changeReason',
            minWidth: 250,
            sortable: true
        },
        {
            title: '状态',
            prop: 'status',
            minWidth: 120,
            sortable: true
        },
        {
            title: '创建人',
            prop: 'createUserName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
