import { useUserStore } from '@/stores/user'

/**
 * 检查按钮权限
 * @param permissionKey 权限标识
 * @returns 是否拥有权限（需同时在allMethod和curUserMethod中存在）
 */
export const hasBtnPermission = (permissionKey: string): boolean => {
    const userStore = useUserStore()
    return (
        userStore.btnAuth.allMethod.includes(permissionKey) &&
        userStore.btnAuth.curUserMethod.includes(permissionKey)
    )
}
