import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseChangeLog/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格保存
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseChangeLog/v1/pub/change`,data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 获取所有信息
export function getCompanyInfo(orgId: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseRegisterInformation/v1/getModel/supplier/${orgId}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseRegisterInformation/v1/saveOrUpdateModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseRegisterInformation/v1/getModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/bizSupplierEnterpriseRegisterInformation/v1/?ids=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
