/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizUserTrainPlanManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizUserTrainPlan;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u8003\u751f\u8bad\u7ec3\u8ba1\u5212"})
@RequestMapping(value={"/biz/userTrain/plan/"})
@ApiGroup(group={"group_biz"})
public class BizUserTrainPlanController
extends BaseController<BizUserTrainPlanManager, BizUserTrainPlan> {
    private static final Logger log = LoggerFactory.getLogger(BizUserTrainPlanController.class);
    @Autowired
    private BizExamPlanManager examPlanManager;
    @Autowired
    private BaseContext baseContext;

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53(\u4fee\u6539\u8bad\u7ec3\u72b6\u6001)")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizUserTrainPlan t) {
        BizUserTrainPlan plan = (BizUserTrainPlan)this.getById(t.getId());
        Assert.notNull((Object)((Object)plan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        BizExamPlan bizExamPlan = (BizExamPlan)((Object)this.examPlanManager.getById((Serializable)((Object)t.getPlanId())));
        Assert.notNull((Object)((Object)bizExamPlan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        if (null == bizExamPlan.getHour()) {
            bizExamPlan.setHour(BigDecimal.ZERO);
        }
        if (t.getHour().doubleValue() >= bizExamPlan.getHour().doubleValue()) {
            t.setStatus("2");
        } else {
            t.setStatus("1");
        }
        boolean result = ((BizUserTrainPlanManager)this.baseService).updateById((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        if (null != bizExamPlan && "0".equals(plan.getStatus())) {
            if (null == bizExamPlan.getRealityNum()) {
                bizExamPlan.setRealityNum(0L);
            }
            bizExamPlan.setRealityNum(bizExamPlan.getRealityNum() + 1L);
            if (bizExamPlan.getRealityNum().doubleValue() == (double)bizExamPlan.getTotalNum().longValue()) {
                bizExamPlan.setPlanStatus("2");
            }
            this.examPlanManager.updateById((Object)bizExamPlan);
        }
        return new CommonResult();
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, String planId) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(BizUserTrainPlan.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            ((BizUserTrainPlanManager)this.baseService).importList(list, planId);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizUserTrainPlan> queryFilter) throws Exception {
        PageList page = this.query(queryFilter);
        ExcelUtils util = new ExcelUtils(BizUserTrainPlan.class);
        util.exportExcel(response, request, page.getRows(), "\u8003\u751f\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u8003\u751f\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u8003\u751f\u8bad\u7ec3\u8ba1\u5212\u6570\u636e\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @PostMapping(value={"/myTrainPlan"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6211\u7684\u8bad\u7ec3\u8ba1\u5212")
    public PageList<BizExamPlan> myTrainPlan(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizExamPlan> queryFilter) {
        queryFilter.addFilter("user_id_", (Object)this.baseContext.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.addFilter("is_dele_", (Object)DelStatusEnum.N.getType(), QueryOP.EQUAL);
        return this.examPlanManager.myTrainPlan(queryFilter);
    }
}

