package com.artfess.examine.vo;

import com.artfess.examine.model.ExamQuestionsOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 试卷题目信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-04
 */
@Data
@ApiModel(value="QuestionsInfoVo对象", description="试卷题目信息")
public class QuestionsInfoVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "问题ID")
    private String questionId;

    @ApiModelProperty(value = "试题题型【字典】（1：单选，2：多选，3：判断，4：填空，5：简答，6：操作）")
    private String type;

    @ApiModelProperty(value = "试题标题")
    private String question;

    @ApiModelProperty(value = "题目分数")
    private BigDecimal score;

    @ApiModelProperty(value = "试题分组标识")
    private String groupFlag;

    @ApiModelProperty(value = "正确答案")
    private String rightOption;

    @ApiModelProperty(value = "答题结果")
    private String result;

    @ApiModelProperty(value = "是否正确【字典】（0：否，1：是）")
    private String isRight;

    @ApiModelProperty(value = "试题难度【字典】(1：简单，2：普通，3：困难)")
    private String difficulty;

    @ApiModelProperty(value = "实际得分")
    private BigDecimal actualScore;

    @ApiModelProperty(value = "科目id")
    private String subId;

    @ApiModelProperty(value = "题目解析")
    private String parsing;

    @ApiModelProperty(value = "评卷方式【字典】（1：系统，2：人工）")
    private String markType;

    @ApiModelProperty(value = "问题选项信息")
    private List<ExamQuestionsOption> options;

}
