package com.artfess.examine.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.vo.QuestionAnalysisVo;
import com.artfess.examine.vo.StatisticalReqVo;
import com.artfess.examine.vo.SubjectQuestionTypeVo;

import java.util.List;

/**
 * 题库试题信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamQuestionsInfoManager extends BaseManager<ExamQuestionsInfo> {

    String createInfo(ExamQuestionsInfo t);

    String updateInfo(ExamQuestionsInfo t);

    ExamQuestionsInfo findById(String id);

    List<ExamQuestionsInfo> randomQuestion(String subjectId, String questionType, Integer numuber);

    List<SubjectQuestionTypeVo> findBySubjectId(String subjectId);

    PageList<ExamQuestionsInfo> findByPage(QueryFilter<ExamQuestionsInfo> queryFilter);

    QuestionAnalysisVo questionAnalysis(StatisticalReqVo reqVo);

    boolean importExcel(ExamQuestionsInfo question);

    List<ExamQuestionsInfo> getQuestionList(List<String> idList);
}
