package com.artfess.examine.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.data.vo.ArchivesManagerVo;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.vo.SettingYearVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 年度考生综合评定表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-28
 */
public interface ExamUserEvaluationDao extends BaseMapper<ExamUserEvaluation> {

    IPage<ExamUserEvaluation> findByPage(IPage<ExamUserEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluation> convert2Wrapper);

    IPage<ExamUserEvaluation> myYearPage(IPage<ExamUserEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluation> convert2Wrapper);

    List<JSONObject> getSubjectInfo(@Param("vo") SettingYearVo t);

    List<JSONObject> getPositionPaper(@Param("vo") SettingYearVo t);

    List<JSONObject> findByPositionId(@Param("positionId") String positionId, @Param("type") String type);

    List<JSONObject> offineInfo(@Param("orgId") String orgId, @Param("year") String year);

    List<String> gwxlSubjectNames(@Param("orgId") String orgId, @Param("type") String type);

    List<String> zygtxlSubjectNames(@Param("orgId") String orgId, @Param("type") String type);

    IPage<ArchivesManagerVo> positionArchives(IPage<ExamUserEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluation> convert2Wrapper);

    IPage<ArchivesManagerVo> orgArchives(IPage<ExamUserEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluation> convert2Wrapper);

    IPage<ArchivesManagerVo> subjectArchives(IPage<ExamUserEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluation> convert2Wrapper);

    List<ArchivesManagerVo> getShouldCountMap(@Param("postionIds") Set<String> postionIds);

    List<ArchivesManagerVo> getEvaluationList(@Param("year") String year);

    IPage<UserExamVo> userQualityAnalyse(IPage<ExamUserEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserEvaluation> convert2Wrapper);
}
