package com.artfess.data.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 档案信息vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-04
 */
@Data
public class ArchivesManagerVo {

    private static final long serialVersionUID = 1L;

    private String id;

    @ApiModelProperty(value = "年份")
    private String year;

    @ApiModelProperty(value = "总分数")
    private String totalScore;

    @ApiModelProperty(value = "考核得分")
    private String score;

    @ApiModelProperty(value = "应考试人数")
    private Long shouldCount;

    @ApiModelProperty(value = "平均分")
    private BigDecimal avgScore;

    @ApiModelProperty(value = "实际考试人数")
    private Long actualCount;

    @ApiModelProperty(value = "缺考人数")
    private Long lackCount;

    @ApiModelProperty(value = "参考率")
    private String referRate;

    @ApiModelProperty(value = "及格人数")
    private Long passCount;

    @ApiModelProperty(value = "不及格人数")
    private Long noPassCount;

    @ApiModelProperty(value = "及格率")
    private String passRate;

    @ApiModelProperty(value = "不及格率")
    private String noPassRate;

    @ApiModelProperty(value = "课目名称")
    private String subjectName;

    @ApiModelProperty(value = "课目ID")
    private String subjectId;

    @ApiModelProperty(value = "岗位id")
    private String positionId;

    @ApiModelProperty(value = "岗位名称")
    private String posName;

    @ApiModelProperty(value = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "用户姓名")
    private String userName;

    @ApiModelProperty(value = "评定等级")
    private String level;

    @ApiModelProperty(value = "优秀率")
    private String excellentRate;

    @ApiModelProperty(value = "考核时间")
    private LocalDateTime evaluationTime;

}
